/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.AttributeBin;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.ShaderBin;
import javax.media.j3d.TexCoordGenerationRetained;
import javax.media.j3d.TextureAttributesRetained;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.TransparentRenderingInfo;
import javax.media.j3d.VirtualUniverse;

class TextureBin
implements ObjectUpdate {
    TextureUnitStateRetained[] texUnitState = null;
    private int lastActiveTexUnitIndex;
    private int numActiveTexUnit;
    RenderBin renderBin = null;
    EnvironmentSet environmentSet = null;
    AttributeBin attributeBin = null;
    ShaderBin shaderBin = null;
    TextureBin next = null;
    TextureBin prev = null;
    int equivalent = 0;
    AppearanceRetained app = null;
    int soleUserCompDirty;
    static final int SOLE_USER_DIRTY_REF = 1;
    static final int SOLE_USER_DIRTY_TA = 2;
    static final int SOLE_USER_DIRTY_TC = 4;
    static final int SOLE_USER_DIRTY_TEXTURE = 8;
    static final int SOLE_USER_DIRTY_TUS = 16;
    HashMap addOpaqueRMs = new HashMap();
    HashMap addTransparentRMs = new HashMap();
    HashMap opaqueRenderMoleculeMap = new HashMap();
    HashMap transparentRenderMoleculeMap = new HashMap();
    RenderMolecule opaqueRMList = null;
    RenderMolecule transparentRMList = null;
    TransparentRenderingInfo parentTInfo;
    int numRenderMolecules = 0;
    int numEditingRenderMolecules = 0;
    int tbFlag = 0;
    static final int ON_RENDER_BIN_LIST = 1;
    static final int ON_UPDATE_LIST = 2;
    static final int SOLE_USER = 4;
    static final int CONTIGUOUS_ACTIVE_UNITS = 8;
    static final int RESORT = 16;
    static final int ON_UPDATE_CHECK_LIST = 32;
    static final int USE_DISPLAYLIST = -2;
    static final int USE_VERTEXARRAY = -1;

    TextureBin(TextureUnitStateRetained[] textureUnitStateRetainedArray, AppearanceRetained appearanceRetained, RenderBin renderBin) {
        this.renderBin = renderBin;
        this.tbFlag = 0;
        this.reset(textureUnitStateRetainedArray, appearanceRetained);
    }

    void reset(TextureUnitStateRetained[] textureUnitStateRetainedArray, AppearanceRetained appearanceRetained) {
        this.prev = null;
        this.next = null;
        this.opaqueRMList = null;
        this.transparentRMList = null;
        this.numEditingRenderMolecules = 0;
        this.tbFlag &= 0xFFFFFFFB;
        if (VirtualUniverse.mc.allowSoleUser && appearanceRetained != null && (appearanceRetained.changedFrequent & 0x40E) != 0) {
            this.tbFlag |= 4;
        }
        this.app = (this.tbFlag & 4) != 0 ? appearanceRetained : null;
        this.resetTextureState(textureUnitStateRetainedArray);
        if ((this.tbFlag & 1) == 0) {
            this.renderBin.addTextureBin(this);
            this.tbFlag |= 1;
        }
    }

    void resetTextureState(TextureUnitStateRetained[] textureUnitStateRetainedArray) {
        boolean bl = false;
        this.numActiveTexUnit = 0;
        this.lastActiveTexUnitIndex = 0;
        boolean bl2 = (this.tbFlag & 4) != 0;
        TextureRetained textureRetained = null;
        this.tbFlag |= 8;
        if (textureUnitStateRetainedArray != null) {
            bl = false;
            if (this.texUnitState == null || this.texUnitState.length != textureUnitStateRetainedArray.length) {
                this.texUnitState = new TextureUnitStateRetained[textureUnitStateRetainedArray.length];
            } else if (this.texUnitState.length > 0 && this.texUnitState[0] != null) {
                textureRetained = this.texUnitState[0].texture;
            }
            for (int i = 0; i < textureUnitStateRetainedArray.length; ++i) {
                TextureRetained textureRetained2;
                if (textureUnitStateRetainedArray[i] == null) {
                    this.texUnitState[i] = null;
                    bl = true;
                    continue;
                }
                if (this.texUnitState[i] == null) {
                    this.texUnitState[i] = new TextureUnitStateRetained();
                }
                if (bl2 || textureUnitStateRetainedArray[i].changedFrequent != 0) {
                    this.texUnitState[i].mirror = textureUnitStateRetainedArray[i];
                }
                if ((textureRetained2 = this.texUnitState[i].texture) != null) {
                    textureRetained2.decTextureBinRefCount(this);
                    if (bl2 && textureRetained2.textureBinRefCount == 0 && textureRetained2 != textureUnitStateRetainedArray[i].texture) {
                        this.renderBin.addTextureResourceFreeList(textureRetained2);
                    }
                }
                this.texUnitState[i].texture = textureUnitStateRetainedArray[i].texture;
                if (this.texUnitState[i].texture != null) {
                    this.texUnitState[i].texture.incTextureBinRefCount(this);
                }
                if (textureUnitStateRetainedArray[i].texAttrs != null) {
                    if (textureUnitStateRetainedArray[i].texAttrs.changedFrequent != 0) {
                        this.texUnitState[i].texAttrs = textureUnitStateRetainedArray[i].texAttrs;
                    } else {
                        if (this.texUnitState[i].texAttrs == null || this.texUnitState[i].texAttrs.source != null) {
                            this.texUnitState[i].texAttrs = new TextureAttributesRetained();
                        }
                        this.texUnitState[i].texAttrs.set(textureUnitStateRetainedArray[i].texAttrs);
                        this.texUnitState[i].texAttrs.mirrorCompDirty = true;
                        this.texUnitState[i].texAttrs.mirror = bl2 ? textureUnitStateRetainedArray[i].texAttrs : null;
                    }
                } else {
                    this.texUnitState[i].texAttrs = null;
                }
                if (textureUnitStateRetainedArray[i].texGen != null) {
                    if (textureUnitStateRetainedArray[i].texGen.changedFrequent != 0) {
                        this.texUnitState[i].texGen = textureUnitStateRetainedArray[i].texGen;
                    } else {
                        if (this.texUnitState[i].texGen == null || this.texUnitState[i].texGen.source != null) {
                            this.texUnitState[i].texGen = new TexCoordGenerationRetained();
                        }
                        this.texUnitState[i].texGen.set(textureUnitStateRetainedArray[i].texGen);
                        this.texUnitState[i].texGen.mirrorCompDirty = true;
                        this.texUnitState[i].texGen.mirror = bl2 ? textureUnitStateRetainedArray[i].texGen : null;
                    }
                } else {
                    this.texUnitState[i].texGen = null;
                }
                if (this.texUnitState[i].isTextureEnabled()) {
                    this.lastActiveTexUnitIndex = i;
                    this.numActiveTexUnit = i + 1;
                    if (!bl) continue;
                    this.tbFlag &= 0xFFFFFFF7;
                    continue;
                }
                bl = true;
            }
            if (this.texUnitState[0] == null && textureRetained != null || this.texUnitState[0] != null && this.texUnitState[0].texture != textureRetained) {
                this.tbFlag |= 0x10;
            }
        } else {
            if (this.texUnitState != null && this.texUnitState[0].texture != null) {
                this.tbFlag |= 0x10;
            }
            this.texUnitState = null;
        }
        this.soleUserCompDirty = 0;
    }

    void clear() {
        this.app = null;
        if (this.texUnitState != null) {
            for (int i = 0; i < this.texUnitState.length; ++i) {
                if (this.texUnitState[i] == null) continue;
                if (this.texUnitState[i].texture != null) {
                    TextureRetained textureRetained = this.texUnitState[i].texture;
                    textureRetained.decTextureBinRefCount(this);
                    if (textureRetained.textureBinRefCount == 0) {
                        this.renderBin.addTextureResourceFreeList(textureRetained);
                    }
                    this.texUnitState[i].texture = null;
                }
                this.texUnitState[i].mirror = null;
                this.texUnitState[i].texture = null;
                if (this.texUnitState[i].texAttrs != null && this.texUnitState[i].texAttrs.source != null) {
                    this.texUnitState[i].texAttrs = null;
                }
                if (this.texUnitState[i].texGen == null || this.texUnitState[i].texGen.source == null) continue;
                this.texUnitState[i].texGen = null;
            }
        }
    }

    boolean equals(TextureUnitStateRetained[] textureUnitStateRetainedArray, RenderAtom renderAtom) {
        boolean bl = false;
        if ((this.tbFlag & 4) != 0 || renderAtom.app != null && (renderAtom.app.changedFrequent & 0x40E) != 0) {
            if (this.app == renderAtom.app) {
                if (this.numEditingRenderMolecules == 0) {
                    if (this.soleUserCompDirty == 0) {
                        this.renderBin.tbUpdateList.add(this);
                    }
                    this.soleUserCompDirty |= 1;
                }
                return true;
            }
            return false;
        }
        if (this.texUnitState == null && textureUnitStateRetainedArray == null) {
            return true;
        }
        if (this.texUnitState == null || textureUnitStateRetainedArray == null) {
            return false;
        }
        if (textureUnitStateRetainedArray.length != this.texUnitState.length) {
            return false;
        }
        for (int i = 0; i < this.texUnitState.length; ++i) {
            if (!(this.texUnitState[i] == null ? textureUnitStateRetainedArray[i] != null : !this.texUnitState[i].equivalent(textureUnitStateRetainedArray[i]))) continue;
            return false;
        }
        if ((this.tbFlag & 1) == 0) {
            this.renderBin.addTextureBin(this);
            this.tbFlag |= 1;
        }
        return true;
    }

    public void updateNodeComponent() {
        if ((this.tbFlag & 1) == 0) {
            return;
        }
        if ((this.tbFlag & 4) != 0 && (this.soleUserCompDirty & 1) != 0) {
            this.resetTextureState(this.app.texUnitState);
            return;
        }
        if (this.texUnitState == null) {
            this.soleUserCompDirty = 0;
            return;
        }
        if ((this.soleUserCompDirty & 0x10) != 0) {
            TextureUnitStateRetained textureUnitStateRetained = null;
            boolean bl = (this.tbFlag & 4) != 0;
            for (int i = 0; i < this.texUnitState.length; ++i) {
                TextureUnitStateRetained textureUnitStateRetained2 = this.texUnitState[i];
                if (textureUnitStateRetained2 == null || textureUnitStateRetained2.mirror == null) continue;
                textureUnitStateRetained = (TextureUnitStateRetained)textureUnitStateRetained2.mirror;
                if (textureUnitStateRetained2.texture != textureUnitStateRetained.texture) {
                    if (textureUnitStateRetained2.texture != null) {
                        textureUnitStateRetained2.texture.decTextureBinRefCount(this);
                    }
                    textureUnitStateRetained2.texture = textureUnitStateRetained.texture;
                    if (textureUnitStateRetained2.texture != null) {
                        textureUnitStateRetained2.texture.incTextureBinRefCount(this);
                    }
                    if (i == 0) {
                        this.tbFlag |= 0x10;
                    }
                }
                if (textureUnitStateRetained.texAttrs != null) {
                    if (textureUnitStateRetained.texAttrs.changedFrequent != 0) {
                        textureUnitStateRetained2.texAttrs = textureUnitStateRetained.texAttrs;
                    } else {
                        if (textureUnitStateRetained2.texAttrs == null || textureUnitStateRetained2.texAttrs.source != null) {
                            textureUnitStateRetained2.texAttrs = new TextureAttributesRetained();
                        }
                        textureUnitStateRetained2.texAttrs.set(textureUnitStateRetained.texAttrs);
                        textureUnitStateRetained2.texAttrs.mirrorCompDirty = true;
                        textureUnitStateRetained2.texAttrs.mirror = bl ? textureUnitStateRetained.texAttrs : null;
                    }
                } else {
                    textureUnitStateRetained2.texAttrs = null;
                }
                if (textureUnitStateRetained.texGen != null) {
                    if (textureUnitStateRetained.texGen.changedFrequent != 0) {
                        textureUnitStateRetained2.texGen = textureUnitStateRetained.texGen;
                        continue;
                    }
                    if (textureUnitStateRetained2.texGen == null || textureUnitStateRetained2.texGen.source != null) {
                        textureUnitStateRetained2.texGen = new TexCoordGenerationRetained();
                    }
                    textureUnitStateRetained2.texGen.set(textureUnitStateRetained.texGen);
                    textureUnitStateRetained2.texGen.mirrorCompDirty = true;
                    if (bl) {
                        textureUnitStateRetained2.texGen.mirror = textureUnitStateRetained.texGen;
                        continue;
                    }
                    textureUnitStateRetained2.texGen.mirror = null;
                    continue;
                }
                textureUnitStateRetained2.texGen = null;
            }
            this.soleUserCompDirty |= 8;
            this.soleUserCompDirty &= 0xFFFFFFF9;
        }
        if ((this.soleUserCompDirty & 8) != 0) {
            boolean bl = false;
            this.numActiveTexUnit = 0;
            this.lastActiveTexUnitIndex = 0;
            this.tbFlag |= 8;
            for (int i = 0; i < this.texUnitState.length; ++i) {
                if (this.texUnitState[i] != null && this.texUnitState[i].isTextureEnabled()) {
                    this.lastActiveTexUnitIndex = i;
                    this.numActiveTexUnit = i + 1;
                    if (!bl) continue;
                    this.tbFlag &= 0xFFFFFFF7;
                    continue;
                }
                bl = true;
            }
        }
        if ((this.soleUserCompDirty & 2) != 0) {
            for (int i = 0; i < this.texUnitState.length; ++i) {
                if (this.texUnitState[i] == null || this.texUnitState[i].texAttrs == null || this.texUnitState[i].texAttrs.mirror == null || this.texUnitState[i].texAttrs.mirror.changedFrequent == 0) continue;
                this.texUnitState[i].texAttrs = (TextureAttributesRetained)this.texUnitState[i].texAttrs.mirror;
            }
        }
        if ((this.soleUserCompDirty & 4) != 0) {
            for (int i = 0; i < this.texUnitState.length; ++i) {
                if (this.texUnitState[i] == null || this.texUnitState[i].texGen == null || this.texUnitState[i].texGen.mirror == null || this.texUnitState[i].texGen.mirror.changedFrequent == 0) continue;
                this.texUnitState[i].texGen = (TexCoordGenerationRetained)this.texUnitState[i].texGen.mirror;
            }
        }
        this.soleUserCompDirty = 0;
    }

    public void updateObject() {
        if (!this.addOpaqueRMs.isEmpty()) {
            this.opaqueRMList = this.addAll(this.opaqueRenderMoleculeMap, this.addOpaqueRMs, this.opaqueRMList, true);
        }
        if (!this.addTransparentRMs.isEmpty()) {
            if (this.transparentRMList == null && (this.renderBin.transpSortMode == 0 || this.environmentSet.lightBin.geometryBackground != null)) {
                this.transparentRMList = this.addAll(this.transparentRenderMoleculeMap, this.addTransparentRMs, this.transparentRMList, false);
                if (this.transparentRMList != null) {
                    this.renderBin.addTransparentObject(this);
                }
            } else {
                this.transparentRMList = this.addAll(this.transparentRenderMoleculeMap, this.addTransparentRMs, this.transparentRMList, false);
            }
        }
        this.tbFlag &= 0xFFFFFFFD;
    }

    RenderMolecule addAll(HashMap hashMap, HashMap hashMap2, RenderMolecule renderMolecule, boolean bl) {
        Collection collection = hashMap2.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RenderMolecule renderMolecule2;
            boolean bl2 = false;
            ArrayList arrayList = (ArrayList)iterator.next();
            RenderMolecule renderMolecule3 = (RenderMolecule)arrayList.get(0);
            if (renderMolecule3.isOpaqueOrInOG != bl) continue;
            RenderMolecule renderMolecule4 = (RenderMolecule)hashMap.get(renderMolecule3.localToVworld);
            if (renderMolecule4 == null) {
                renderMolecule4 = renderMolecule3;
                hashMap.put(renderMolecule3.localToVworld, renderMolecule4);
                if (renderMolecule == null) {
                    renderMolecule = renderMolecule3;
                    renderMolecule3.nextMap = null;
                    renderMolecule3.prevMap = null;
                    renderMolecule.dirtyAttrsAcrossRms = 945;
                } else {
                    renderMolecule3.nextMap = renderMolecule;
                    renderMolecule.prevMap = renderMolecule3;
                    renderMolecule = renderMolecule3;
                    renderMolecule.nextMap.checkEquivalenceWithLeftNeighbor(renderMolecule3, 945);
                }
            } else {
                renderMolecule2 = this.insertRenderMolecule(renderMolecule3, renderMolecule4);
                if (renderMolecule2 != null) {
                    if (renderMolecule4.prevMap != null) {
                        renderMolecule4.prevMap.nextMap = renderMolecule2;
                    }
                    renderMolecule2.prevMap = renderMolecule4.prevMap;
                    renderMolecule4.prevMap = null;
                    renderMolecule4 = renderMolecule2;
                    bl2 = true;
                }
            }
            for (int i = 1; i < arrayList.size(); ++i) {
                renderMolecule3 = (RenderMolecule)arrayList.get(i);
                if (renderMolecule3.isOpaqueOrInOG != bl || (renderMolecule2 = this.insertRenderMolecule(renderMolecule3, renderMolecule4)) == null) continue;
                if (renderMolecule4.prevMap != null) {
                    renderMolecule4.prevMap.nextMap = renderMolecule2;
                }
                renderMolecule2.prevMap = renderMolecule4.prevMap;
                renderMolecule4.prevMap = null;
                renderMolecule4 = renderMolecule2;
                bl2 = true;
            }
            if (!bl2) continue;
            hashMap.put(renderMolecule3.localToVworld, renderMolecule4);
            if (renderMolecule4.prevMap != null) {
                renderMolecule4.checkEquivalenceWithLeftNeighbor(renderMolecule4.prevMap, 945);
                continue;
            }
            renderMolecule = renderMolecule4;
            renderMolecule.dirtyAttrsAcrossRms = 945;
        }
        hashMap2.clear();
        return renderMolecule;
    }

    RenderMolecule insertRenderMolecule(RenderMolecule renderMolecule, RenderMolecule renderMolecule2) {
        RenderMolecule renderMolecule3 = renderMolecule2;
        while (renderMolecule3 != null) {
            if (renderMolecule3.material == renderMolecule.material || renderMolecule3.definingMaterial != null && renderMolecule3.definingMaterial.equivalent(renderMolecule.definingMaterial)) {
                RenderMolecule renderMolecule4;
                renderMolecule.next = renderMolecule3;
                renderMolecule.prev = renderMolecule3.prev;
                if (renderMolecule3.prev == null) {
                    renderMolecule4 = renderMolecule2 = renderMolecule;
                } else {
                    renderMolecule3.prev.next = renderMolecule;
                    renderMolecule4 = null;
                }
                renderMolecule3.prev = renderMolecule;
                renderMolecule.checkEquivalenceWithBothNeighbors(945);
                return renderMolecule4;
            }
            renderMolecule3 = renderMolecule3.next;
            while (renderMolecule3 != null && (renderMolecule3.dirtyAttrsAcrossRms & 1) == 0) {
                renderMolecule3 = renderMolecule3.next;
            }
        }
        renderMolecule.next = renderMolecule2;
        renderMolecule2.prev = renderMolecule;
        renderMolecule2 = renderMolecule;
        renderMolecule.checkEquivalenceWithBothNeighbors(945);
        return renderMolecule2;
    }

    void addRenderMolecule(RenderMolecule renderMolecule, RenderBin renderBin) {
        renderMolecule.textureBin = this;
        HashMap hashMap = renderMolecule.isOpaqueOrInOG ? this.addOpaqueRMs : this.addTransparentRMs;
        ArrayList<RenderMolecule> arrayList = (ArrayList<RenderMolecule>)hashMap.get(renderMolecule.localToVworld);
        if (arrayList == null) {
            arrayList = new ArrayList<RenderMolecule>();
            hashMap.put(renderMolecule.localToVworld, arrayList);
        }
        arrayList.add(renderMolecule);
        if ((this.tbFlag & 2) == 0) {
            this.tbFlag |= 2;
            renderBin.objUpdateList.add(this);
        }
    }

    void removeRenderMolecule(RenderMolecule renderMolecule) {
        int n;
        HashMap hashMap;
        HashMap hashMap2;
        RenderMolecule renderMolecule2;
        boolean bl = false;
        renderMolecule.textureBin = null;
        if (renderMolecule.isOpaqueOrInOG) {
            renderMolecule2 = this.opaqueRMList;
            hashMap2 = this.opaqueRenderMoleculeMap;
            hashMap = this.addOpaqueRMs;
        } else {
            renderMolecule2 = this.transparentRMList;
            hashMap2 = this.transparentRenderMoleculeMap;
            hashMap = this.addTransparentRMs;
        }
        ArrayList arrayList = (ArrayList)hashMap.get(renderMolecule.localToVworld);
        if (arrayList != null && (n = arrayList.indexOf(renderMolecule)) != -1) {
            arrayList.remove(n);
            if (arrayList.isEmpty()) {
                hashMap.remove(renderMolecule.localToVworld);
            }
            renderMolecule.prev = null;
            renderMolecule.next = null;
            bl = true;
        }
        if (!bl) {
            RenderMolecule renderMolecule3 = this.removeOneRM(renderMolecule, hashMap2, renderMolecule2);
            renderMolecule.soleUserCompDirty = 0;
            renderMolecule.onUpdateList = 0;
            if (renderMolecule.definingPolygonAttributes != null && renderMolecule.definingPolygonAttributes.changedFrequent != 0) {
                renderMolecule.definingPolygonAttributes = null;
            }
            if (renderMolecule.definingLineAttributes != null && renderMolecule.definingLineAttributes.changedFrequent != 0) {
                renderMolecule.definingLineAttributes = null;
            }
            if (renderMolecule.definingPointAttributes != null && renderMolecule.definingPointAttributes.changedFrequent != 0) {
                renderMolecule.definingPointAttributes = null;
            }
            if (renderMolecule.definingMaterial != null && renderMolecule.definingMaterial.changedFrequent != 0) {
                renderMolecule.definingMaterial = null;
            }
            if (renderMolecule.definingColoringAttributes != null && renderMolecule.definingColoringAttributes.changedFrequent != 0) {
                renderMolecule.definingColoringAttributes = null;
            }
            if (renderMolecule.definingTransparency != null && renderMolecule.definingTransparency.changedFrequent != 0) {
                renderMolecule.definingTransparency = null;
            }
            this.renderBin.removeRenderMolecule(renderMolecule);
            if (renderMolecule.isOpaqueOrInOG) {
                this.opaqueRMList = renderMolecule3;
            } else {
                this.transparentRMList = renderMolecule3;
            }
        }
        if (!(renderMolecule.isOpaqueOrInOG || this.transparentRMList != null || this.renderBin.transpSortMode != 0 && this.environmentSet.lightBin.geometryBackground == null)) {
            this.renderBin.removeTransparentObject(this);
        } else if (this.parentTInfo != null && this.parentTInfo.rm == renderMolecule) {
            this.parentTInfo.rm = this.transparentRMList;
        }
        if (this.opaqueRenderMoleculeMap.isEmpty() && this.addOpaqueRMs.isEmpty() && this.transparentRenderMoleculeMap.isEmpty() && this.addTransparentRMs.isEmpty()) {
            if ((this.tbFlag & 1) != 0) {
                this.tbFlag &= 0xFFFFFFFE;
                this.renderBin.removeTextureBin(this);
            }
            this.shaderBin.removeTextureBin(this);
            this.texUnitState = null;
        }
    }

    void updateAttributes(Canvas3D canvas3D) {
        boolean bl;
        boolean bl2 = bl = (canvas3D.canvasDirty & 0xC00) != 0;
        if (canvas3D.textureBin == this && !bl) {
            return;
        }
        canvas3D.textureBin = this;
        int n = -1;
        boolean bl3 = this.shaderBin.shaderProgram != null;
        int n2 = bl3 ? canvas3D.maxTextureImageUnits : canvas3D.maxTextureUnits;
        boolean bl4 = false;
        if (this.numActiveTexUnit > n2) {
            bl4 = true;
        }
        if (bl4) {
            canvas3D.setNumActiveTexUnit(0);
        } else {
            canvas3D.setNumActiveTexUnit(this.numActiveTexUnit);
        }
        if (this.numActiveTexUnit <= 0 || bl4) {
            if (canvas3D.getLastActiveTexUnit() >= 0) {
                if (canvas3D.multiTexAccelerated) {
                    for (int i = 0; i <= canvas3D.getLastActiveTexUnit(); ++i) {
                        canvas3D.resetTexture(canvas3D.ctx, i);
                    }
                    canvas3D.setNumActiveTexUnit(0);
                    canvas3D.activeTextureUnit(canvas3D.ctx, 0);
                } else {
                    canvas3D.resetTexture(canvas3D.ctx, -1);
                }
                canvas3D.setLastActiveTexUnit(-1);
            }
        } else {
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < this.texUnitState.length && n4 < canvas3D.texUnitState.length; ++n4, ++n3) {
                if (this.texUnitState[n3] != null && this.texUnitState[n3].isTextureEnabled()) {
                    if (bl || canvas3D.texUnitState[n4].mirror == null || canvas3D.texUnitState[n4].mirror != this.texUnitState[n3].mirror) {
                        this.texUnitState[n3].updateNative(n4, canvas3D, false, false);
                        canvas3D.texUnitState[n4].mirror = this.texUnitState[n3].mirror;
                    }
                    n = n4;
                    continue;
                }
                if (n4 > canvas3D.getLastActiveTexUnit()) continue;
                canvas3D.resetTexture(canvas3D.ctx, n4);
            }
            for (n3 = n4; n3 <= canvas3D.getLastActiveTexUnit(); ++n3) {
                canvas3D.resetTexture(canvas3D.ctx, n3);
            }
            canvas3D.setLastActiveTexUnit(n);
            canvas3D.activeTextureUnit(canvas3D.ctx, 0);
        }
        canvas3D.canvasDirty &= 0xFFFFFBFF;
    }

    void render(Canvas3D canvas3D) {
        this.render(canvas3D, this.opaqueRMList);
    }

    void render(Canvas3D canvas3D, Object object) {
        canvas3D.texLinearMode = false;
        canvas3D.setStateToUpdate(3, this);
        if (this.texUnitState != null && VirtualUniverse.mc.isD3D()) {
            for (int i = 0; i < this.texUnitState.length; ++i) {
                TextureUnitStateRetained textureUnitStateRetained = this.texUnitState[i];
                if (textureUnitStateRetained == null || !textureUnitStateRetained.isTextureEnabled() || textureUnitStateRetained.texGen == null || textureUnitStateRetained.texGen.genMode != 0) continue;
                canvas3D.texLinearMode = true;
            }
        }
        this.renderList(canvas3D, -2, object);
    }

    void renderList(Canvas3D canvas3D, int n, Object object) {
        assert (n < 0);
        if (object instanceof RenderMolecule) {
            this.renderList(canvas3D, n, (RenderMolecule)object);
        } else if (object instanceof TransparentRenderingInfo) {
            this.renderList(canvas3D, n, (TransparentRenderingInfo)object);
        }
    }

    void renderList(Canvas3D canvas3D, int n, RenderMolecule renderMolecule) {
        assert (n < 0);
        int n2 = 0;
        boolean bl = true;
        RenderMolecule renderMolecule2 = renderMolecule;
        while (renderMolecule2 != null) {
            n2 = bl ? renderMolecule2.dirtyAttrsAcrossRms : (n2 |= renderMolecule2.dirtyAttrsAcrossRms);
            bl = renderMolecule2.render(canvas3D, n, n2);
            if (renderMolecule2.next == null) {
                renderMolecule2 = renderMolecule2.nextMap;
                continue;
            }
            renderMolecule2 = renderMolecule2.next;
        }
    }

    void renderList(Canvas3D canvas3D, int n, TransparentRenderingInfo transparentRenderingInfo) {
        assert (n < 0);
        RenderMolecule renderMolecule = transparentRenderingInfo.rm;
        if (renderMolecule.isSwitchOn()) {
            renderMolecule.transparentSortRender(canvas3D, n, transparentRenderingInfo);
        }
    }

    void changeLists(RenderMolecule renderMolecule) {
        HashMap hashMap;
        RenderMolecule renderMolecule2;
        RenderMolecule renderMolecule3;
        RenderMolecule renderMolecule4 = null;
        HashMap hashMap2 = null;
        boolean bl = false;
        if (renderMolecule.isOpaqueOrInOG) {
            if (this.opaqueRMList == null && renderMolecule.prev == null && renderMolecule.prevMap == null && renderMolecule.next == null && renderMolecule.nextMap == null) {
                bl = true;
            } else {
                renderMolecule4 = this.opaqueRMList;
                hashMap2 = this.opaqueRenderMoleculeMap;
            }
        } else if (this.transparentRMList == null && renderMolecule.prev == null && renderMolecule.prevMap == null && renderMolecule.next == null && renderMolecule.nextMap == null) {
            bl = true;
        } else {
            renderMolecule4 = this.transparentRMList;
            hashMap2 = this.transparentRenderMoleculeMap;
        }
        if (!bl) {
            renderMolecule3 = this.removeOneRM(renderMolecule, hashMap2, renderMolecule4);
            if (renderMolecule.isOpaqueOrInOG) {
                this.opaqueRMList = renderMolecule3;
            } else {
                this.transparentRMList = renderMolecule3;
                if (this.transparentRMList == null && (this.renderBin.transpSortMode == 0 || this.environmentSet.lightBin.geometryBackground != null)) {
                    this.renderBin.removeTransparentObject(this);
                }
                if (this.renderBin.transpSortMode == 1 && this.environmentSet.lightBin.geometryBackground == null) {
                    renderMolecule.addRemoveTransparentObject(this.renderBin, false);
                }
            }
        }
        renderMolecule.evalAlphaUsage(this.shaderBin.attributeBin.definingRenderingAttributes, this.texUnitState);
        boolean bl2 = renderMolecule.isOpaqueOrInOG = renderMolecule.isOpaque() || renderMolecule.inOrderedGroup;
        if (renderMolecule.isOpaqueOrInOG) {
            renderMolecule2 = this.opaqueRMList;
            hashMap = this.opaqueRenderMoleculeMap;
            this.markDlistAsDirty(renderMolecule);
        } else {
            renderMolecule2 = this.transparentRMList;
            hashMap = this.transparentRenderMoleculeMap;
            if ((renderMolecule.primaryMoleculeType & RenderMolecule.DLIST_MOLECULE) != 0 && this.renderBin.transpSortMode != 0) {
                this.renderBin.addDisplayListResourceFreeList(renderMolecule);
                this.renderBin.removeDirtyRenderMolecule(renderMolecule);
                renderMolecule.vwcBounds.set(null);
                renderMolecule.displayListId = 0;
                renderMolecule.displayListIdObj = null;
                RenderAtomListInfo renderAtomListInfo = renderMolecule.primaryRenderAtomList;
                while (renderAtomListInfo != null) {
                    renderAtomListInfo.groupType = RenderAtom.SEPARATE_DLIST_PER_RINFO;
                    if (renderAtomListInfo.renderAtom.dlistIds == null) {
                        renderAtomListInfo.renderAtom.dlistIds = new int[renderAtomListInfo.renderAtom.rListInfo.length];
                        for (int i = 0; i < renderAtomListInfo.renderAtom.dlistIds.length; ++i) {
                            renderAtomListInfo.renderAtom.dlistIds[i] = -1;
                        }
                    }
                    if (renderAtomListInfo.renderAtom.dlistIds[renderAtomListInfo.index] == -1) {
                        renderAtomListInfo.renderAtom.dlistIds[renderAtomListInfo.index] = VirtualUniverse.mc.getDisplayListId();
                        this.renderBin.addDlistPerRinfo.add(renderAtomListInfo);
                    }
                    renderAtomListInfo = renderAtomListInfo.next;
                }
                renderMolecule.primaryMoleculeType = RenderMolecule.SEPARATE_DLIST_PER_RINFO_MOLECULE;
            } else {
                this.markDlistAsDirty(renderMolecule);
            }
        }
        RenderMolecule renderMolecule5 = (RenderMolecule)hashMap.get(renderMolecule.localToVworld);
        if (renderMolecule5 == null) {
            renderMolecule5 = renderMolecule;
            hashMap.put(renderMolecule.localToVworld, renderMolecule5);
            if (renderMolecule2 == null) {
                renderMolecule2 = renderMolecule;
                renderMolecule.nextMap = null;
                renderMolecule.prevMap = null;
            } else {
                renderMolecule.nextMap = renderMolecule2;
                renderMolecule2.prevMap = renderMolecule;
                renderMolecule2 = renderMolecule;
                renderMolecule2.nextMap.checkEquivalenceWithLeftNeighbor(renderMolecule, 945);
            }
            renderMolecule2.dirtyAttrsAcrossRms = 945;
        } else {
            renderMolecule3 = this.insertRenderMolecule(renderMolecule, renderMolecule5);
            if (renderMolecule3 != null) {
                if (renderMolecule5.prevMap != null) {
                    renderMolecule5.prevMap.nextMap = renderMolecule3;
                }
                renderMolecule3.prevMap = renderMolecule5.prevMap;
                renderMolecule5.prevMap = null;
                renderMolecule5 = renderMolecule3;
                hashMap.put(renderMolecule.localToVworld, renderMolecule5);
                if (renderMolecule5.prevMap != null) {
                    renderMolecule5.checkEquivalenceWithLeftNeighbor(renderMolecule5.prevMap, 945);
                } else {
                    renderMolecule2.dirtyAttrsAcrossRms = 945;
                    renderMolecule2 = renderMolecule5;
                }
            }
        }
        if (renderMolecule.isOpaqueOrInOG) {
            this.opaqueRMList = renderMolecule2;
        } else {
            if (this.transparentRMList == null && (this.renderBin.transpSortMode == 0 || this.environmentSet.lightBin.geometryBackground != null)) {
                this.transparentRMList = renderMolecule2;
                this.renderBin.addTransparentObject(this);
            } else {
                this.transparentRMList = renderMolecule2;
            }
            if (this.renderBin.transpSortMode == 1 && this.environmentSet.lightBin.geometryBackground == null) {
                renderMolecule.addRemoveTransparentObject(this.renderBin, true);
            }
        }
    }

    RenderMolecule removeOneRM(RenderMolecule renderMolecule, HashMap hashMap, RenderMolecule renderMolecule2) {
        RenderMolecule renderMolecule3 = renderMolecule2;
        if (renderMolecule.prev != null && renderMolecule.next != null) {
            renderMolecule.prev.next = renderMolecule.next;
            renderMolecule.next.prev = renderMolecule.prev;
            renderMolecule.next.checkEquivalenceWithLeftNeighbor(renderMolecule.prev, 945);
        } else if (renderMolecule.prev != null && renderMolecule.next == null) {
            renderMolecule.prev.next = renderMolecule.next;
            renderMolecule.prev.nextMap = renderMolecule.nextMap;
            if (renderMolecule.nextMap != null) {
                renderMolecule.nextMap.prevMap = renderMolecule.prev;
                renderMolecule.nextMap.checkEquivalenceWithLeftNeighbor(renderMolecule.prev, 945);
            }
        } else if (renderMolecule.prev == null && renderMolecule.next != null) {
            renderMolecule.next.prev = null;
            renderMolecule.next.prevMap = renderMolecule.prevMap;
            if (renderMolecule.prevMap != null) {
                renderMolecule.prevMap.nextMap = renderMolecule.next;
                renderMolecule.next.checkEquivalenceWithLeftNeighbor(renderMolecule.prevMap, 945);
            } else {
                renderMolecule3 = renderMolecule.next;
                renderMolecule3.dirtyAttrsAcrossRms = 945;
            }
            hashMap.put(renderMolecule.localToVworld, renderMolecule.next);
        } else if (renderMolecule.prev == null && renderMolecule.next == null) {
            if (renderMolecule.prevMap != null) {
                renderMolecule.prevMap.nextMap = renderMolecule.nextMap;
            } else {
                renderMolecule3 = renderMolecule.nextMap;
                if (renderMolecule.nextMap != null) {
                    renderMolecule3.dirtyAttrsAcrossRms = 945;
                }
            }
            if (renderMolecule.nextMap != null) {
                renderMolecule.nextMap.prevMap = renderMolecule.prevMap;
                if (renderMolecule.prevMap != null) {
                    renderMolecule.nextMap.checkEquivalenceWithLeftNeighbor(renderMolecule.prevMap, 945);
                }
            }
            hashMap.remove(renderMolecule.localToVworld);
        }
        renderMolecule.prev = null;
        renderMolecule.next = null;
        renderMolecule.prevMap = null;
        renderMolecule.nextMap = null;
        return renderMolecule3;
    }

    void markDlistAsDirty(RenderMolecule renderMolecule) {
        if (renderMolecule.primaryMoleculeType == RenderMolecule.DLIST_MOLECULE) {
            this.renderBin.addDirtyRenderMolecule(renderMolecule);
        } else if (renderMolecule.primaryMoleculeType == RenderMolecule.SEPARATE_DLIST_PER_RINFO_MOLECULE) {
            RenderAtomListInfo renderAtomListInfo = renderMolecule.primaryRenderAtomList;
            while (renderAtomListInfo != null) {
                this.renderBin.addDlistPerRinfo.add(renderAtomListInfo);
                renderAtomListInfo = renderAtomListInfo.next;
            }
        }
    }

    void decrActiveRenderMolecule() {
        --this.numEditingRenderMolecules;
        if (this.numEditingRenderMolecules == 0) {
            this.shaderBin.decrActiveTextureBin();
        }
    }

    void incrActiveRenderMolecule() {
        if (this.numEditingRenderMolecules == 0) {
            this.shaderBin.incrActiveTextureBin();
        }
        ++this.numEditingRenderMolecules;
    }
}

