/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.xml;

import com.romraider.ECUEditor;
import com.romraider.Settings;
import com.romraider.maps.DataCell;
import com.romraider.maps.Rom;
import com.romraider.maps.RomID;
import com.romraider.maps.Scale;
import com.romraider.maps.Table;
import com.romraider.maps.Table1D;
import com.romraider.maps.Table2D;
import com.romraider.maps.Table3D;
import com.romraider.maps.TableSwitch;
import com.romraider.swing.DebugPanel;
import com.romraider.swing.JProgressPane;
import com.romraider.util.LogManager;
import com.romraider.util.ObjectCloner;
import com.romraider.xml.DOMHelper;
import com.romraider.xml.RomAttributeParser;
import com.romraider.xml.RomNotFoundException;
import com.romraider.xml.TableIsOmittedException;
import com.romraider.xml.TableNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.modelmbean.XMLParseException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMRomUnmarshaller {
    private static final Logger LOGGER = Logger.getLogger(DOMRomUnmarshaller.class);
    private JProgressPane progress = null;
    private List<Scale> scales = new ArrayList<Scale>();
    private Settings settings;
    private ECUEditor parent;

    public DOMRomUnmarshaller(Settings settings, ECUEditor eCUEditor) {
        this.settings = settings;
        this.parent = eCUEditor;
    }

    public Rom unmarshallXMLDefinition(Node node, byte[] byArray, JProgressPane jProgressPane) throws RomNotFoundException, XMLParseException, StackOverflowError, Exception {
        Node node2;
        int n;
        this.progress = jProgressPane;
        NodeList nodeList = node.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equalsIgnoreCase("scalingbase")) continue;
            this.scales.add(this.unmarshallScale(node2, new Scale()));
        }
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equalsIgnoreCase("rom")) continue;
            NodeList nodeList2 = node2.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                RomID romID;
                Node node3 = nodeList2.item(i);
                if (node3.getNodeType() != 1 || !node3.getNodeName().equalsIgnoreCase("romid") || (romID = this.unmarshallRomID(node3, new RomID())).getInternalIdString().length() <= 0 || !DOMRomUnmarshaller.foundMatch(romID, byArray)) continue;
                Rom rom = this.unmarshallRom(node2, new Rom());
                rom.getRomID().setRamOffset(rom.getRomID().getFileSize() - byArray.length);
                return rom;
            }
        }
        throw new RomNotFoundException();
    }

    public static boolean foundMatch(RomID romID, byte[] byArray) {
        String string = romID.getInternalIdString();
        if (string.length() > 2 && string.substring(0, 2).equalsIgnoreCase("0x")) {
            try {
                string = string.substring(2);
                int[] nArray = new int[string.length() / 2];
                for (int i = 0; i < nArray.length; ++i) {
                    if ((byArray[romID.getInternalIdAddress() + i] & 0xFF) == Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16)) continue;
                    return false;
                }
                return true;
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Error finding match", (Throwable)exception);
                return false;
            }
        }
        try {
            String string2 = new String(byArray, romID.getInternalIdAddress(), romID.getInternalIdString().length());
            return DOMRomUnmarshaller.foundMatchByString(romID, string2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean foundMatchByString(RomID romID, String string) {
        try {
            return string.equalsIgnoreCase(romID.getInternalIdString());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void main(String[] stringArray) {
        LogManager.initDebugLogging();
        DOMRomUnmarshaller dOMRomUnmarshaller = new DOMRomUnmarshaller(new Settings(), new ECUEditor());
        dOMRomUnmarshaller.parent.dispose();
        RomID romID = new RomID();
        romID.setInternalIdString("Asdfd");
        byte[] byArray = "Asdfd".getBytes();
        LOGGER.debug((Object)DOMRomUnmarshaller.foundMatch(romID, byArray));
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 1;
        LOGGER.debug((Object)DOMRomUnmarshaller.foundMatch(romID, byArray));
        romID.setInternalIdString("0x010101");
        LOGGER.debug((Object)DOMRomUnmarshaller.foundMatch(romID, byArray));
    }

    public Rom unmarshallRom(Node node, Rom rom) throws XMLParseException, RomNotFoundException, StackOverflowError, Exception {
        NodeList nodeList = node.getChildNodes();
        this.progress.update("Creating tables...", 15);
        if (!DOMHelper.unmarshallAttribute(node, "base", "none").equalsIgnoreCase("none")) {
            rom = this.getBaseRom(node.getParentNode(), DOMHelper.unmarshallAttribute(node, "base", "none"), rom);
            rom.getRomID().setObsolete(false);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            int n = (int)((double)i / (double)nodeList.getLength() * 40.0);
            this.progress.update("Creating tables...", 10 + n);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().equalsIgnoreCase("romid")) {
                rom.setRomID(this.unmarshallRomID(node2, rom.getRomID()));
                continue;
            }
            if (!node2.getNodeName().equalsIgnoreCase("table")) continue;
            Table table = null;
            try {
                table = rom.getTable(DOMHelper.unmarshallAttribute(node2, "name", "unknown"));
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            try {
                table = this.unmarshallTable(node2, table, rom);
                table.setRom(rom);
                rom.addTable(table);
                continue;
            }
            catch (TableIsOmittedException tableIsOmittedException) {
                if (table == null) continue;
                rom.removeTable(table.getName());
                continue;
            }
            catch (XMLParseException xMLParseException) {
                LOGGER.error((Object)"Error unmarshalling rom", (Throwable)xMLParseException);
            }
        }
        return rom;
    }

    public Rom getBaseRom(Node node, String string, Rom rom) throws XMLParseException, RomNotFoundException, StackOverflowError, Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equalsIgnoreCase("rom")) continue;
            NodeList nodeList2 = node2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                RomID romID;
                Node node3 = nodeList2.item(j);
                if (node3.getNodeType() != 1 || !node3.getNodeName().equalsIgnoreCase("romid") || !(romID = this.unmarshallRomID(node3, new RomID())).getXmlid().equalsIgnoreCase(string)) continue;
                Rom rom2 = this.unmarshallRom(node2, rom);
                rom2.getRomID().setObsolete(false);
                return rom2;
            }
        }
        throw new RomNotFoundException();
    }

    public RomID unmarshallRomID(Node node, RomID romID) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().equalsIgnoreCase("xmlid")) {
                romID.setXmlid(DOMHelper.unmarshallText(node2));
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("internalidaddress")) {
                romID.setInternalIdAddress(RomAttributeParser.parseHexString(DOMHelper.unmarshallText(node2)));
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("internalidstring")) {
                romID.setInternalIdString(DOMHelper.unmarshallText(node2));
                if (romID.getInternalIdString() != null) continue;
                romID.setInternalIdString("");
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("caseid")) {
                romID.setCaseId(DOMHelper.unmarshallText(node2));
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("ecuid")) {
                romID.setEcuId(DOMHelper.unmarshallText(node2));
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("make")) {
                romID.setMake(DOMHelper.unmarshallText(node2));
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("market")) {
                romID.setMarket(DOMHelper.unmarshallText(node2));
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("model")) {
                romID.setModel(DOMHelper.unmarshallText(node2));
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("submodel")) {
                romID.setSubModel(DOMHelper.unmarshallText(node2));
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("transmission")) {
                romID.setTransmission(DOMHelper.unmarshallText(node2));
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("year")) {
                romID.setYear(DOMHelper.unmarshallText(node2));
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("flashmethod")) {
                romID.setFlashMethod(DOMHelper.unmarshallText(node2));
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("memmodel")) {
                romID.setMemModel(DOMHelper.unmarshallText(node2));
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("filesize")) {
                romID.setFileSize(RomAttributeParser.parseFileSize(DOMHelper.unmarshallText(node2)));
                continue;
            }
            if (!node2.getNodeName().equalsIgnoreCase("obsolete")) continue;
            romID.setObsolete(Boolean.parseBoolean(DOMHelper.unmarshallText(node2)));
        }
        return romID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Table unmarshallTable(Node node, Table table, Rom rom) throws XMLParseException, TableIsOmittedException, Exception {
        if (DOMHelper.unmarshallAttribute(node, "omit", "false").equalsIgnoreCase("true")) {
            throw new TableIsOmittedException();
        }
        if (!DOMHelper.unmarshallAttribute(node, "base", "none").equalsIgnoreCase("none")) {
            try {
                table = (Table)ObjectCloner.deepCopy(rom.getTable(DOMHelper.unmarshallAttribute(node, "base", "none")));
            }
            catch (TableNotFoundException tableNotFoundException) {
            }
            catch (NullPointerException nullPointerException) {
                JOptionPane.showMessageDialog(this.parent, new DebugPanel(nullPointerException, this.parent.getSettings().getSupportURL()), "Exception", 0);
            }
        }
        try {
            if (table.getType() >= 1) {
                // empty if block
            }
        }
        catch (NullPointerException nullPointerException) {
            if (DOMHelper.unmarshallAttribute(node, "type", "unknown").equalsIgnoreCase("3D")) {
                table = new Table3D(this.settings);
            }
            if (DOMHelper.unmarshallAttribute(node, "type", "unknown").equalsIgnoreCase("2D")) {
                table = new Table2D(this.settings);
            }
            if (DOMHelper.unmarshallAttribute(node, "type", "unknown").equalsIgnoreCase("1D")) {
                table = new Table1D(this.settings);
            }
            if (DOMHelper.unmarshallAttribute(node, "type", "unknown").equalsIgnoreCase("X Axis") || DOMHelper.unmarshallAttribute(node, "type", "unknown").equalsIgnoreCase("Y Axis")) {
                table = new Table1D(this.settings);
            }
            if (DOMHelper.unmarshallAttribute(node, "type", "unknown").equalsIgnoreCase("Static Y Axis") || DOMHelper.unmarshallAttribute(node, "type", "unknown").equalsIgnoreCase("Static X Axis")) {
                table = new Table1D(this.settings);
            }
            if (!DOMHelper.unmarshallAttribute(node, "type", "unknown").equalsIgnoreCase("Switch")) {
                throw new XMLParseException("Error loading table.");
            }
            table = new TableSwitch(this.settings);
        }
        table.setName(DOMHelper.unmarshallAttribute(node, "name", table.getName()));
        table.setType(RomAttributeParser.parseTableType(DOMHelper.unmarshallAttribute(node, "type", String.valueOf(table.getType()))));
        if (DOMHelper.unmarshallAttribute(node, "beforeram", "false").equalsIgnoreCase("true")) {
            table.setBeforeRam(true);
        }
        if (DOMHelper.unmarshallAttribute(node, "type", "unknown").equalsIgnoreCase("Static X Axis") || DOMHelper.unmarshallAttribute(node, "type", "unknown").equalsIgnoreCase("Static Y Axis")) {
            table.setIsStatic(true);
            ((Table1D)table).setIsAxis(true);
        } else if (DOMHelper.unmarshallAttribute(node, "type", "unknown").equalsIgnoreCase("X Axis") || DOMHelper.unmarshallAttribute(node, "type", "unknown").equalsIgnoreCase("Y Axis")) {
            ((Table1D)table).setIsAxis(true);
        }
        table.setCategory(DOMHelper.unmarshallAttribute(node, "category", table.getCategory()));
        table.setStorageType(RomAttributeParser.parseStorageType(DOMHelper.unmarshallAttribute(node, "storagetype", String.valueOf(table.getStorageType()))));
        table.setEndian(RomAttributeParser.parseEndian(DOMHelper.unmarshallAttribute(node, "endian", String.valueOf(table.getEndian()))));
        table.setStorageAddress(RomAttributeParser.parseHexString(DOMHelper.unmarshallAttribute(node, "storageaddress", String.valueOf(table.getStorageAddress()))));
        table.setDescription(DOMHelper.unmarshallAttribute(node, "description", table.getDescription()));
        table.setDataSize(DOMHelper.unmarshallAttribute(node, "sizey", DOMHelper.unmarshallAttribute(node, "sizex", table.getDataSize())));
        table.setFlip(DOMHelper.unmarshallAttribute(node, "flipy", DOMHelper.unmarshallAttribute(node, "flipx", table.getFlip())));
        table.setUserLevel(DOMHelper.unmarshallAttribute(node, "userlevel", table.getUserLevel()));
        table.setLocked(DOMHelper.unmarshallAttribute(node, "locked", table.isLocked()));
        table.setLogParam(DOMHelper.unmarshallAttribute(node, "logparam", table.getLogParam()));
        if (table.getType() == 3) {
            ((Table3D)table).setSwapXY(DOMHelper.unmarshallAttribute(node, "swapxy", ((Table3D)table).getSwapXY()));
            ((Table3D)table).setFlipX(DOMHelper.unmarshallAttribute(node, "flipx", ((Table3D)table).getFlipX()));
            ((Table3D)table).setFlipY(DOMHelper.unmarshallAttribute(node, "flipy", ((Table3D)table).getFlipY()));
            ((Table3D)table).setSizeX(DOMHelper.unmarshallAttribute(node, "sizex", ((Table3D)table).getSizeX()));
            ((Table3D)table).setSizeY(DOMHelper.unmarshallAttribute(node, "sizey", ((Table3D)table).getSizeY()));
        }
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (true) {
            block40: {
                Serializable serializable;
                Node node2;
                block41: {
                    block42: {
                        if (n >= nodeList.getLength()) {
                            return table;
                        }
                        node2 = nodeList.item(n);
                        if (node2.getNodeType() != 1) break block40;
                        if (!node2.getNodeName().equalsIgnoreCase("table")) break block41;
                        if (table.getType() != 2) break block42;
                        if (RomAttributeParser.parseTableType(DOMHelper.unmarshallAttribute(node2, "type", "unknown")) == 5 || RomAttributeParser.parseTableType(DOMHelper.unmarshallAttribute(node2, "type", "unknown")) == 4) {
                            serializable = (Table1D)this.unmarshallTable(node2, ((Table2D)table).getAxis(), rom);
                            if (((Table)serializable).getDataSize() != table.getDataSize()) {
                                ((Table)serializable).setDataSize(table.getDataSize());
                            }
                            ((Table)serializable).setData(((Table2D)table).getAxis().getData());
                            ((Table)serializable).setAxisParent(table);
                            ((Table2D)table).setAxis((Table1D)serializable);
                        }
                        break block40;
                    }
                    if (table.getType() != 3) break block40;
                    if (RomAttributeParser.parseTableType(DOMHelper.unmarshallAttribute(node2, "type", "unknown")) == 4) {
                        serializable = (Table1D)this.unmarshallTable(node2, ((Table3D)table).getXAxis(), rom);
                        if (((Table)serializable).getDataSize() != ((Table3D)table).getSizeX()) {
                            ((Table)serializable).setDataSize(((Table3D)table).getSizeX());
                        }
                        ((Table)serializable).setData(((Table3D)table).getXAxis().getData());
                        ((Table)serializable).setAxisParent(table);
                        ((Table3D)table).setXAxis((Table1D)serializable);
                        break block40;
                    } else if (RomAttributeParser.parseTableType(DOMHelper.unmarshallAttribute(node2, "type", "unknown")) == 5) {
                        serializable = (Table1D)this.unmarshallTable(node2, ((Table3D)table).getYAxis(), rom);
                        if (((Table)serializable).getDataSize() != ((Table3D)table).getSizeY()) {
                            ((Table)serializable).setDataSize(((Table3D)table).getSizeY());
                        }
                        ((Table)serializable).setData(((Table3D)table).getYAxis().getData());
                        ((Table)serializable).setAxisParent(table);
                        ((Table3D)table).setYAxis((Table1D)serializable);
                    }
                    break block40;
                }
                if (node2.getNodeName().equalsIgnoreCase("scaling")) {
                    serializable = new Scale();
                    try {
                        serializable = table.getScaleByName(DOMHelper.unmarshallAttribute(node2, "name", "x"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    table.setScale(this.unmarshallScale(node2, (Scale)serializable));
                } else if (node2.getNodeName().equalsIgnoreCase("data")) {
                    serializable = new DataCell();
                    ((DataCell)serializable).setDisplayValue(DOMHelper.unmarshallText(node2));
                    ((DataCell)serializable).setTable(table);
                    table.addStaticDataCell((DataCell)serializable);
                } else if (node2.getNodeName().equalsIgnoreCase("description")) {
                    table.setDescription(DOMHelper.unmarshallText(node2));
                } else if (node2.getNodeName().equalsIgnoreCase("state")) {
                    if (DOMHelper.unmarshallAttribute(node2, "name", "").equalsIgnoreCase("on")) {
                        ((TableSwitch)table).setOnValues(DOMHelper.unmarshallAttribute(node2, "data", "0"));
                    } else if (DOMHelper.unmarshallAttribute(node2, "name", "").equalsIgnoreCase("off")) {
                        ((TableSwitch)table).setOffValues(DOMHelper.unmarshallAttribute(node2, "data", "0"));
                    }
                }
            }
            ++n;
        }
    }

    private Scale unmarshallScale(Node node, Scale scale) {
        String string = DOMHelper.unmarshallAttribute(node, "base", "none");
        if (!string.equalsIgnoreCase("none")) {
            for (Scale scale2 : this.scales) {
                if (!scale2.getName().equalsIgnoreCase(string)) continue;
                try {
                    scale = (Scale)ObjectCloner.deepCopy(scale2);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.parent, new DebugPanel(exception, this.parent.getSettings().getSupportURL()), "Exception", 0);
                }
            }
        }
        scale.setName(DOMHelper.unmarshallAttribute(node, "name", scale.getName()));
        scale.setUnit(DOMHelper.unmarshallAttribute(node, "units", scale.getUnit()));
        scale.setExpression(DOMHelper.unmarshallAttribute(node, "expression", scale.getExpression()));
        scale.setByteExpression(DOMHelper.unmarshallAttribute(node, "to_byte", scale.getByteExpression()));
        scale.setFormat(DOMHelper.unmarshallAttribute(node, "format", "#"));
        scale.setMax(DOMHelper.unmarshallAttribute(node, "max", 0.0));
        scale.setMin(DOMHelper.unmarshallAttribute(node, "min", 0.0));
        scale.setCoarseIncrement(DOMHelper.unmarshallAttribute(node, "coarseincrement", DOMHelper.unmarshallAttribute(node, "increment", scale.getCoarseIncrement())));
        scale.setFineIncrement(DOMHelper.unmarshallAttribute(node, "fineincrement", scale.getFineIncrement()));
        return scale;
    }
}

