/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.util;

public final class HexUtil {
    private HexUtil() {
    }

    public static String asHex(byte[] byArray) {
        return HexUtil.bytesToHex(byArray).toUpperCase();
    }

    public static byte[] asBytes(String string) {
        if (string.indexOf(32) >= 0) {
            string = string.replaceAll(" ", "");
        }
        if (string.startsWith("0x")) {
            string = string.substring(2);
        }
        return HexUtil.hexToBytes(string);
    }

    public static String bytesToHex(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        HexUtil.bytesToHexAppend(byArray, n, n2, stringBuffer);
        return stringBuffer.toString();
    }

    public static void bytesToHexAppend(byte[] byArray, int n, int n2, StringBuffer stringBuffer) {
        stringBuffer.ensureCapacity(stringBuffer.length() + n2 * 2);
        for (int i = n; i < n + n2 && i < byArray.length; ++i) {
            stringBuffer.append(Character.forDigit(byArray[i] >>> 4 & 0xF, 16));
            stringBuffer.append(Character.forDigit(byArray[i] & 0xF, 16));
        }
    }

    public static String bytesToHex(byte[] byArray) {
        return HexUtil.bytesToHex(byArray, 0, byArray.length);
    }

    public static byte[] hexToBytes(String string) {
        return HexUtil.hexToBytes(string, 0);
    }

    public static byte[] hexToBytes(String string, int n) {
        byte[] byArray = new byte[n + (1 + string.length()) / 2];
        HexUtil.hexToBytes(string, byArray, n);
        return byArray;
    }

    public static void hexToBytes(String string, byte[] byArray, int n) throws NumberFormatException, IndexOutOfBoundsException {
        int n2 = string.length();
        if (n2 % 2 != 0) {
            string = '0' + string;
        }
        if (byArray.length < n + n2 / 2) {
            throw new IndexOutOfBoundsException("Output buffer too small for input (" + byArray.length + "<" + n + n2 / 2 + ")");
        }
        for (int i = 0; i < n2; i += 2) {
            byte by = (byte)Character.digit(string.charAt(i), 16);
            byte by2 = (byte)Character.digit(string.charAt(i + 1), 16);
            if (by < 0 || by2 < 0) {
                throw new NumberFormatException();
            }
            byArray[n + i / 2] = (byte)(by << 4 | by2);
        }
    }

    public static int hexToInt(String string) {
        if (string.length() > 2 && string.substring(0, 2).equalsIgnoreCase("0x")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        return Integer.parseInt(string, 16);
    }

    public static String intToHexString(int n) {
        return "0x" + Integer.toHexString(n).toUpperCase();
    }
}

