/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.maps.Table;
import com.romraider.swing.JTableChooser;
import com.romraider.swing.TablePropertyPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class TableMenuBar
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = -695692646459410510L;
    private Table table;
    private JMenu fileMenu = new JMenu("Table");
    private JMenuItem graph = new JMenuItem("View Graph");
    private JMenu compareMenu = new JMenu("Compare");
    private JRadioButtonMenuItem compareOriginal = new JRadioButtonMenuItem("Show Changes");
    private JRadioButtonMenuItem compareMap = new JRadioButtonMenuItem("Compare to Another Map");
    private JRadioButtonMenuItem compareOff = new JRadioButtonMenuItem("Off");
    private JMenu compareDisplay = new JMenu("Display");
    private JRadioButtonMenuItem comparePercent = new JRadioButtonMenuItem("Percent Difference");
    private JRadioButtonMenuItem compareAbsolute = new JRadioButtonMenuItem("Absolute Difference");
    private JMenuItem close = new JMenuItem("Close Table");
    private JMenu editMenu = new JMenu("Edit");
    private JMenuItem undoSel = new JMenuItem("Undo Selected Changes");
    private JMenuItem undoAll = new JMenuItem("Undo All Changes");
    private JMenuItem revert = new JMenuItem("Set Revert Point");
    private JMenuItem copySel = new JMenuItem("Copy Selection");
    private JMenuItem copyTable = new JMenuItem("Copy Table");
    private JMenuItem paste = new JMenuItem("Paste");
    private JMenu viewMenu = new JMenu("View");
    private JMenuItem tableProperties = new JMenuItem("Table Properties");
    private ButtonGroup compareGroup = new ButtonGroup();
    private ButtonGroup compareDisplayGroup = new ButtonGroup();

    public TableMenuBar(Table table) {
        this.table = table;
        this.add(this.fileMenu);
        this.fileMenu.add(this.graph);
        this.fileMenu.add(this.compareMenu);
        this.compareMenu.add(this.compareOriginal);
        this.compareMenu.add(this.compareMap);
        this.compareMenu.add(this.compareOff);
        this.compareMenu.add(new JSeparator());
        this.compareMenu.add(this.compareDisplay);
        this.compareDisplay.add(this.comparePercent);
        this.compareDisplay.add(this.compareAbsolute);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.close);
        this.close.setText("Close " + table.getName());
        this.compareMenu.setMnemonic('C');
        this.compareOriginal.setMnemonic('C');
        this.compareMap.setMnemonic('M');
        this.compareOff.setMnemonic('O');
        this.compareOff.setSelected(true);
        this.compareDisplay.setMnemonic('D');
        this.comparePercent.setMnemonic('P');
        this.compareAbsolute.setMnemonic('A');
        this.compareAbsolute.setSelected(true);
        this.compareGroup.add(this.compareOriginal);
        this.compareGroup.add(this.compareMap);
        this.compareGroup.add(this.compareOff);
        this.compareDisplayGroup.add(this.comparePercent);
        this.compareDisplayGroup.add(this.compareAbsolute);
        this.compareOriginal.addActionListener(this);
        this.compareMap.addActionListener(this);
        this.compareOff.addActionListener(this);
        this.comparePercent.addActionListener(this);
        this.compareAbsolute.addActionListener(this);
        this.add(this.editMenu);
        this.editMenu.add(this.undoSel);
        this.editMenu.add(this.undoAll);
        this.editMenu.add(this.revert);
        this.editMenu.add(new JSeparator());
        this.editMenu.add(this.copySel);
        this.editMenu.add(this.copyTable);
        this.editMenu.add(new JSeparator());
        this.editMenu.add(this.paste);
        this.editMenu.setMnemonic('E');
        this.copySel.setMnemonic('C');
        this.copyTable.setMnemonic('T');
        this.paste.setMnemonic('P');
        this.copySel.addActionListener(this);
        this.copyTable.addActionListener(this);
        this.paste.addActionListener(this);
        this.add(this.viewMenu);
        this.viewMenu.add(this.tableProperties);
        this.viewMenu.setMnemonic('V');
        this.tableProperties.setMnemonic('P');
        this.tableProperties.addActionListener(this);
        this.graph.addActionListener(this);
        this.undoSel.addActionListener(this);
        this.undoAll.addActionListener(this);
        this.revert.addActionListener(this);
        this.close.addActionListener(this);
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setMnemonic('T');
        this.graph.setMnemonic('G');
        this.undoSel.setMnemonic('U');
        this.undoAll.setMnemonic('A');
        this.revert.setMnemonic('R');
        this.close.setMnemonic('X');
        this.graph.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.undoAll) {
            this.table.undoAll();
        } else if (actionEvent.getSource() == this.revert) {
            this.table.setRevertPoint();
        } else if (actionEvent.getSource() == this.undoSel) {
            this.table.undoSelected();
        } else if (actionEvent.getSource() == this.close) {
            this.table.getRom().getContainer().removeDisplayTable(this.table.getFrame());
        } else if (actionEvent.getSource() == this.tableProperties) {
            JOptionPane.showMessageDialog(this.table, new TablePropertyPanel(this.table), this.table.getName() + " Table Properties", 1);
        } else if (actionEvent.getSource() == this.copySel) {
            this.table.copySelection();
        } else if (actionEvent.getSource() == this.copyTable) {
            this.table.copyTable();
        } else if (actionEvent.getSource() == this.paste) {
            this.table.paste();
        } else if (actionEvent.getSource() == this.compareOff) {
            this.table.compare(0);
        } else if (actionEvent.getSource() == this.compareOriginal) {
            this.table.compare(1);
        } else if (actionEvent.getSource() == this.compareMap) {
            JTableChooser jTableChooser = new JTableChooser();
            if (jTableChooser.showChooser(this.table.getRom().getContainer().getImages(), this.table.getRom().getContainer(), this.table)) {
                this.table.pasteCompare();
                this.table.compare(2);
            }
        } else if (actionEvent.getSource() == this.compareAbsolute) {
            this.table.setCompareDisplay(1);
        } else if (actionEvent.getSource() == this.comparePercent) {
            this.table.setCompareDisplay(0);
        }
    }
}

