/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.maps.Rom;
import com.romraider.maps.Table;
import com.romraider.swing.RomTreeNode;
import com.romraider.swing.TableTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class RomCellRenderer
implements TreeCellRenderer {
    JLabel fileName;
    JLabel carInfo;
    DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();

    public RomCellRenderer() {
        this.fileName = new JLabel(" ");
        this.fileName.setFont(new Font("Tahoma", 1, 11));
        this.fileName.setHorizontalAlignment(0);
        this.carInfo = new JLabel(" ");
        this.carInfo.setFont(new Font("Tahoma", 0, 10));
        this.carInfo.setHorizontalAlignment(0);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Component component = null;
        if (object != null && object instanceof RomTreeNode) {
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof Rom) {
                Rom rom = (Rom)object2;
                if (bl2) {
                    this.fileName.setText("- " + rom.getFileName());
                } else {
                    this.fileName.setText("+ " + rom.getFileName());
                }
                this.carInfo.setText(rom.getRomIDString() + ", " + rom.getRomID().getCaseId() + "; " + rom.getRomID().getYear() + " " + rom.getRomID().getMake() + " " + rom.getRomID().getModel() + " " + rom.getRomID().getSubModel() + ", " + rom.getRomID().getTransmission());
                JPanel jPanel = new JPanel(new GridLayout(2, 1));
                jPanel.add(this.fileName);
                jPanel.add(this.carInfo);
                if (bl) {
                    jPanel.setBackground(new Color(220, 220, 255));
                    jPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 225)));
                } else {
                    jPanel.setBorder(BorderFactory.createLineBorder(new Color(220, 0, 0)));
                    jPanel.setBackground(new Color(255, 210, 210));
                }
                jPanel.setPreferredSize(new Dimension(jTree.getParent().getWidth(), 30));
                jPanel.setMaximumSize(new Dimension(jTree.getParent().getWidth(), 30));
                jPanel.setEnabled(jTree.isEnabled());
                component = jPanel;
            }
        } else if (object != null && object instanceof TableTreeNode) {
            Table table = (Table)((DefaultMutableTreeNode)object).getUserObject();
            JPanel jPanel = new JPanel(new GridLayout(1, 1));
            jPanel.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            JLabel jLabel = new JLabel("");
            jPanel.setBackground(Color.WHITE);
            if (table.getType() == 1) {
                jLabel = new JLabel(table.getName() + " ", new ImageIcon("./graphics/1d.gif"), 2);
            } else if (table.getType() == 2) {
                jLabel = new JLabel(table.getName() + " ", new ImageIcon("./graphics/2d.gif"), 2);
            } else if (table.getType() == 3) {
                jLabel = new JLabel(table.getName() + " ", new ImageIcon("./graphics/3d.gif"), 2);
            } else if (table.getType() == 6) {
                jLabel = new JLabel(table.getName() + " ", new ImageIcon("./graphics/switch.gif"), 2);
            }
            jPanel.add(jLabel);
            jLabel.setFont(new Font("Tahoma", 0, 11));
            if (bl) {
                jPanel.setBackground(new Color(220, 220, 255));
                jPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 225)));
            }
            if (table.getUserLevel() == 5) {
                jLabel.setForeground(new Color(255, 150, 150));
                jLabel.setFont(new Font("Tahoma", 2, 11));
            } else if (table.getUserLevel() > table.getRom().getContainer().getSettings().getUserLevel()) {
                jLabel.setFont(new Font("Tahoma", 2, 11));
            }
            component = jPanel;
        }
        if (component == null) {
            component = this.defaultRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
        return component;
    }
}

