/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.ECUEditor;
import com.romraider.logger.ecu.ui.handler.table.TableUpdateHandler;
import com.romraider.maps.RomID;
import com.romraider.maps.Table;
import com.romraider.swing.JProgressPane;
import com.romraider.xml.TableNotFoundException;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rom
implements Serializable {
    private static final long serialVersionUID = 7865405179738828128L;
    private static final Logger LOGGER = Logger.getLogger(Rom.class);
    private RomID romID = new RomID();
    private String fileName = "";
    private File fullFileName = new File(".");
    private Vector<Table> tables = new Vector();
    private ECUEditor container;
    private byte[] binData;
    private String parent = "";
    private boolean isAbstract = false;

    public void addTable(Table table) {
        boolean bl = false;
        for (int i = 0; i < this.tables.size(); ++i) {
            if (!this.tables.get(i).getName().equalsIgnoreCase(table.getName())) continue;
            this.tables.remove(i);
            this.tables.add(i, table);
            bl = true;
            break;
        }
        if (!bl) {
            this.tables.add(table);
        }
    }

    public Table getTable(String string) throws TableNotFoundException {
        for (Table table : this.tables) {
            if (!table.getName().equalsIgnoreCase(string)) continue;
            return table;
        }
        throw new TableNotFoundException();
    }

    public List<Table> findTables(String string) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        for (Table table : this.tables) {
            String string2 = table.getName();
            if (!string2.matches(string)) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    public void removeTable(String string) {
        for (int i = 0; i < this.tables.size(); ++i) {
            if (!this.tables.get(i).getName().equalsIgnoreCase(string)) continue;
            this.tables.remove(i);
        }
    }

    public void populateTables(byte[] byArray, JProgressPane jProgressPane) {
        this.binData = byArray;
        for (int i = 0; i < this.getTables().size(); ++i) {
            int n = (int)((double)i / (double)this.getTables().size() * 40.0);
            jProgressPane.update("Populating tables...", 40 + n);
            Table table = this.tables.get(i);
            try {
                if (table.getStorageAddress() != 0) {
                    try {
                        table.populateTable(byArray);
                        TableUpdateHandler.getInstance().registerTable(table);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        LOGGER.error((Object)(table.getName() + " type " + table.getType() + " start " + table.getStorageAddress() + " " + byArray.length + " filesize"), (Throwable)arrayIndexOutOfBoundsException);
                        JOptionPane.showMessageDialog(this.container, "Storage address for table \"" + table.getName() + "\" is out of bounds.\nPlease check ECU definition file.", "ECU Definition Error", 0);
                        this.tables.removeElementAt(i);
                        --i;
                    }
                    continue;
                }
                this.tables.remove(i);
                --i;
                continue;
            }
            catch (NullPointerException nullPointerException) {
                JOptionPane.showMessageDialog(this.container, "There was an error loading table " + table.getName(), "ECU Definition Error", 0);
                this.tables.removeElementAt(i);
            }
        }
    }

    public void setRomID(RomID romID) {
        this.romID = romID;
    }

    public RomID getRomID() {
        return this.romID;
    }

    public String getRomIDString() {
        return this.romID.getXmlid();
    }

    public String toString() {
        String string = "";
        string = string + "\n---- Rom ----" + this.romID.toString();
        for (int i = 0; i < this.getTables().size(); ++i) {
            string = string + this.getTables().get(i);
        }
        string = string + "\n---- End Rom ----";
        return string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public Vector<Table> getTables() {
        return this.tables;
    }

    public ECUEditor getContainer() {
        return this.container;
    }

    public void setContainer(ECUEditor eCUEditor) {
        this.container = eCUEditor;
        for (Table table : this.tables) {
            table.applyColorSettings(eCUEditor.getSettings());
            table.getFrame().pack();
        }
    }

    public byte[] saveFile() {
        for (Table table : this.tables) {
            table.saveFile(this.binData);
        }
        return this.binData;
    }

    public int getRealFileSize() {
        return this.binData.length;
    }

    public File getFullFileName() {
        return this.fullFileName;
    }

    public void setFullFileName(File file) {
        this.fullFileName = file;
        this.setFileName(file.getName());
        for (Table table : this.tables) {
            table.getFrame().updateFileName();
        }
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String string) {
        this.parent = string;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean bl) {
        this.isAbstract = bl;
    }
}

