/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.tab;

import com.romraider.logger.ecu.ui.handler.graph.SpringUtilities;
import com.romraider.logger.ecu.ui.tab.XYTrendline;
import com.romraider.util.ParamChecker;
import jamlab.Polyfit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class LoggerChartPanel
extends JPanel {
    private static final long serialVersionUID = -6579979878171615665L;
    private static final Color DARK_GREY = new Color(80, 80, 80);
    private static final Color LIGHT_GREY = new Color(110, 110, 110);
    private final XYSeries data = new XYSeries((Comparable)((Object)"Data"));
    private final XYTrendline trendline = new XYTrendline(this.data);
    private final XYSeries hilite = new XYSeries((Comparable)((Object)"Hilite"));
    private final String labelX;
    private final String labelY;

    public LoggerChartPanel(String string, String string2) {
        super(new SpringLayout());
        ParamChecker.checkNotNull((Object)string, string2);
        this.labelX = string;
        this.labelY = string2;
        this.addChart();
    }

    public synchronized void addData(double d, double d2) {
        if (this.hilite.getItemCount() == 1) {
            XYDataItem xYDataItem = this.hilite.remove(0);
            this.data.add(xYDataItem);
        }
        this.hilite.add(d, d2);
    }

    public void clear() {
        this.trendline.clear();
        this.hilite.clear();
        this.data.clear();
    }

    public void interpolate(int n) {
        this.trendline.update(n);
    }

    public double[] calculate(double[] dArray) {
        return this.trendline.calculate(dArray);
    }

    public double[] getPolynomialCoefficients() {
        Polyfit polyfit = this.trendline.getPolyFit();
        return polyfit.getPolynomialCoefficients();
    }

    private void addChart() {
        ChartPanel chartPanel = new ChartPanel(this.createChart(), false, true, true, true, true);
        chartPanel.setMinimumSize(new Dimension(400, 300));
        chartPanel.setPreferredSize(new Dimension(500, 400));
        this.add((Component)chartPanel);
        SpringUtilities.makeCompactGrid(this, 1, 1, 2, 2, 2, 2);
    }

    private JFreeChart createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(null, (String)this.labelX, (String)this.labelY, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        jFreeChart.setBackgroundPaint((Paint)Color.BLACK);
        this.configurePlot(jFreeChart);
        this.addSeries(jFreeChart, 0, this.hilite, 4, Color.GREEN);
        this.addTrendLine(jFreeChart, 1, this.trendline, Color.BLUE);
        this.addSeries(jFreeChart, 2, this.data, 2, Color.RED);
        return jFreeChart;
    }

    private void configurePlot(JFreeChart jFreeChart) {
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setBackgroundPaint((Paint)Color.BLACK);
        xYPlot.getDomainAxis().setLabelPaint((Paint)Color.WHITE);
        xYPlot.getRangeAxis().setLabelPaint((Paint)Color.WHITE);
        xYPlot.getDomainAxis().setTickLabelPaint((Paint)LIGHT_GREY);
        xYPlot.getRangeAxis().setTickLabelPaint((Paint)LIGHT_GREY);
        xYPlot.setDomainGridlinePaint((Paint)DARK_GREY);
        xYPlot.setRangeGridlinePaint((Paint)DARK_GREY);
        xYPlot.setOutlinePaint((Paint)DARK_GREY);
        xYPlot.setRenderer((XYItemRenderer)this.buildScatterRenderer(2, Color.RED));
    }

    private XYDotRenderer buildScatterRenderer(int n, Color color) {
        XYDotRenderer xYDotRenderer = new XYDotRenderer();
        xYDotRenderer.setDotHeight(n);
        xYDotRenderer.setDotWidth(n);
        xYDotRenderer.setSeriesPaint(0, (Paint)color);
        return xYDotRenderer;
    }

    private void addTrendLine(JFreeChart jFreeChart, int n, XYTrendline xYTrendline, Color color) {
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setDataset(n, (XYDataset)xYTrendline);
        xYPlot.setRenderer(n, (XYItemRenderer)this.buildTrendLineRenderer(color));
    }

    private void addSeries(JFreeChart jFreeChart, int n, XYSeries xYSeries, int n2, Color color) {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setDataset(n, (XYDataset)xYSeriesCollection);
        xYPlot.setRenderer(n, (XYItemRenderer)this.buildScatterRenderer(n2, color));
    }

    private StandardXYItemRenderer buildTrendLineRenderer(Color color) {
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        standardXYItemRenderer.setSeriesPaint(0, (Paint)color);
        return standardXYItemRenderer;
    }
}

