/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.swing.menubar.action;

import com.romraider.logger.ecu.EcuLogger;
import com.romraider.logger.ecu.ui.swing.menubar.action.AbstractAction;
import com.romraider.logger.ecu.ui.swing.menubar.util.FileHelper;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;

public final class LogFileLocationAction
extends AbstractAction {
    public LogFileLocationAction(EcuLogger ecuLogger) {
        super(ecuLogger);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.setLogFileLocationDialog();
        }
        catch (Exception exception) {
            this.logger.reportError(exception);
        }
    }

    private void setLogFileLocationDialog() throws Exception {
        File file = FileHelper.getFile(this.logger.getSettings().getLoggerOutputDirPath());
        JFileChooser jFileChooser = FileHelper.getLoggerOutputDirFileChooser(file);
        if (jFileChooser.showOpenDialog(this.logger) == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.logger.getSettings().setLoggerOutputDirPath(string);
            this.logger.reportMessage("Log file output location successfully updated: " + string);
        }
    }
}

