/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler.file;

import com.romraider.Settings;
import com.romraider.logger.ecu.exception.FileLoggerException;
import com.romraider.logger.ecu.ui.MessageListener;
import com.romraider.logger.ecu.ui.handler.file.FileLogger;
import com.romraider.util.ParamChecker;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class FileLoggerImpl
implements FileLogger {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private final SimpleDateFormat timestampFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private final Settings settings;
    private final MessageListener messageListener;
    private boolean started;
    private OutputStream os;
    private long startTimestamp;
    private boolean zero;

    public FileLoggerImpl(Settings settings, MessageListener messageListener) {
        ParamChecker.checkNotNull(settings, messageListener);
        this.settings = settings;
        this.messageListener = messageListener;
    }

    public void start() {
        if (!this.started) {
            this.stop();
            try {
                String string = this.buildFilePath();
                this.os = new BufferedOutputStream(new FileOutputStream(string));
                this.messageListener.reportMessageInTitleBar("Started logging to file: " + string);
                this.zero = true;
            }
            catch (Exception exception) {
                this.stop();
                throw new FileLoggerException(exception);
            }
            this.started = true;
        }
    }

    public void stop() {
        if (this.os != null) {
            try {
                this.os.close();
                this.messageListener.reportMessageInTitleBar("Stopped logging to file.");
            }
            catch (Exception exception) {
                throw new FileLoggerException(exception);
            }
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void writeHeaders(String string) {
        this.writeText("Time" + string);
    }

    public void writeLine(String string, long l) {
        this.writeText(this.prependTimestamp(string, l));
    }

    private void writeText(String string) {
        try {
            this.os.write(string.getBytes());
            if (!string.endsWith(NEW_LINE)) {
                this.os.write(NEW_LINE.getBytes());
            }
        }
        catch (Exception exception) {
            this.stop();
            throw new FileLoggerException(exception);
        }
    }

    private String prependTimestamp(String string, long l) {
        String string2;
        if (this.settings.isFileLoggingAbsoluteTimestamp()) {
            string2 = this.timestampFormat.format(new Date(l));
        } else if (this.zero) {
            string2 = "0";
            this.startTimestamp = System.currentTimeMillis();
            this.zero = false;
        } else {
            string2 = String.valueOf(System.currentTimeMillis() - this.startTimestamp);
        }
        return string2 + string;
    }

    private String buildFilePath() {
        String string = this.settings.getLoggerOutputDirPath();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = string + "romraiderlog_" + this.dateFormat.format(new Date()) + ".csv";
        return string;
    }
}

