/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler.dash;

import com.romraider.logger.ecu.definition.EcuDataConvertor;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.handler.dash.GaugeMinMax;
import com.romraider.logger.ecu.ui.handler.dash.GaugeStyle;
import com.romraider.util.ParamChecker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialRange;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;

public class DialGaugeStyle
implements GaugeStyle {
    protected final DefaultValueDataset current = new DefaultValueDataset(0.0);
    protected final DefaultValueDataset max = new DefaultValueDataset(0.0);
    protected final DefaultValueDataset min = new DefaultValueDataset(0.0);
    protected final DialTextAnnotation unitsLabel = new DialTextAnnotation("");
    protected final LoggerData loggerData;
    private double maxValue = Double.MIN_VALUE;
    private double minValue = Double.MAX_VALUE;
    private JPanel panel;

    public DialGaugeStyle(LoggerData loggerData) {
        ParamChecker.checkNotNull(loggerData);
        this.loggerData = loggerData;
    }

    public void apply(JPanel jPanel) {
        this.panel = jPanel;
        this.resetValue();
        this.refreshChart(jPanel);
    }

    private void refreshChart(final JPanel jPanel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFreeChart jFreeChart = DialGaugeStyle.this.buildChart();
                ChartPanel chartPanel = new ChartPanel(jFreeChart);
                chartPanel.setPreferredSize(DialGaugeStyle.this.getChartSize());
                jPanel.removeAll();
                jPanel.add((Component)chartPanel);
                jPanel.revalidate();
            }
        });
    }

    public void refreshTitle() {
        this.refreshChart(this.panel);
    }

    public void updateValue(final double d) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialGaugeStyle.this.current.setValue((Number)d);
            }
        });
        this.updateMinMax(d);
    }

    private void updateMinMax(final double d) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (d > DialGaugeStyle.this.maxValue) {
                    DialGaugeStyle.this.maxValue = d;
                    DialGaugeStyle.this.max.setValue((Number)d);
                } else if (d < DialGaugeStyle.this.minValue) {
                    DialGaugeStyle.this.minValue = d;
                    DialGaugeStyle.this.min.setValue((Number)d);
                }
            }
        });
    }

    public void resetValue() {
        EcuDataConvertor ecuDataConvertor = this.loggerData.getSelectedConvertor();
        GaugeMinMax gaugeMinMax = ecuDataConvertor.getGaugeMinMax();
        double d = gaugeMinMax.min;
        this.updateValue(d);
        this.resetMinMax(d);
    }

    private void resetMinMax(final double d) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialGaugeStyle.this.maxValue = Double.MIN_VALUE;
                DialGaugeStyle.this.minValue = Double.MAX_VALUE;
                DialGaugeStyle.this.max.setValue((Number)d);
                DialGaugeStyle.this.min.setValue((Number)d);
            }
        });
    }

    protected Dimension getChartSize() {
        return new Dimension(250, 270);
    }

    protected JFreeChart buildChart() {
        DialPlot dialPlot = new DialPlot();
        dialPlot.setView(0.0, 0.0, 1.0, 1.0);
        dialPlot.setDataset(0, (ValueDataset)this.current);
        dialPlot.setDataset(1, (ValueDataset)this.max);
        dialPlot.setDataset(2, (ValueDataset)this.min);
        StandardDialFrame standardDialFrame = new StandardDialFrame();
        dialPlot.setDialFrame((DialFrame)standardDialFrame);
        GradientPaint gradientPaint = new GradientPaint(new Point(), new Color(255, 255, 255), new Point(), new Color(170, 170, 220));
        DialBackground dialBackground = new DialBackground((Paint)gradientPaint);
        dialBackground.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL));
        dialPlot.setBackground((DialLayer)dialBackground);
        this.unitsLabel.setFont(new Font("Dialog", 1, 15));
        this.unitsLabel.setRadius(0.7);
        this.unitsLabel.setLabel(this.loggerData.getSelectedConvertor().getUnits());
        dialPlot.addLayer((DialLayer)this.unitsLabel);
        DecimalFormat decimalFormat = new DecimalFormat(this.loggerData.getSelectedConvertor().getFormat());
        DialValueIndicator dialValueIndicator = new DialValueIndicator(0);
        dialValueIndicator.setNumberFormat((NumberFormat)decimalFormat);
        dialPlot.addLayer((DialLayer)dialValueIndicator);
        EcuDataConvertor ecuDataConvertor = this.loggerData.getSelectedConvertor();
        GaugeMinMax gaugeMinMax = ecuDataConvertor.getGaugeMinMax();
        StandardDialScale standardDialScale = new StandardDialScale(gaugeMinMax.min, gaugeMinMax.max, 225.0, -270.0, gaugeMinMax.step, 5);
        standardDialScale.setTickRadius(0.88);
        standardDialScale.setTickLabelOffset(0.15);
        standardDialScale.setTickLabelFont(new Font("Dialog", 0, 12));
        standardDialScale.setTickLabelFormatter((NumberFormat)decimalFormat);
        dialPlot.addScale(0, (DialScale)standardDialScale);
        dialPlot.addScale(1, (DialScale)standardDialScale);
        dialPlot.addScale(2, (DialScale)standardDialScale);
        StandardDialRange standardDialRange = new StandardDialRange(this.rangeLimit(gaugeMinMax, 0.75), gaugeMinMax.max, (Paint)Color.RED);
        standardDialRange.setInnerRadius(0.52);
        standardDialRange.setOuterRadius(0.55);
        dialPlot.addLayer((DialLayer)standardDialRange);
        StandardDialRange standardDialRange2 = new StandardDialRange(this.rangeLimit(gaugeMinMax, 0.5), this.rangeLimit(gaugeMinMax, 0.75), (Paint)Color.ORANGE);
        standardDialRange2.setInnerRadius(0.52);
        standardDialRange2.setOuterRadius(0.55);
        dialPlot.addLayer((DialLayer)standardDialRange2);
        StandardDialRange standardDialRange3 = new StandardDialRange(gaugeMinMax.min, this.rangeLimit(gaugeMinMax, 0.5), (Paint)Color.GREEN);
        standardDialRange3.setInnerRadius(0.52);
        standardDialRange3.setOuterRadius(0.55);
        dialPlot.addLayer((DialLayer)standardDialRange3);
        DialPointer.Pointer pointer = new DialPointer.Pointer(0);
        dialPlot.addLayer((DialLayer)pointer);
        DialPointer.Pin pin = new DialPointer.Pin(1);
        pin.setRadius(0.84);
        pin.setPaint((Paint)Color.RED);
        pin.setStroke((Stroke)new BasicStroke(1.5f));
        dialPlot.addLayer((DialLayer)pin);
        DialPointer.Pin pin2 = new DialPointer.Pin(2);
        pin2.setRadius(0.84);
        pin2.setPaint((Paint)Color.BLUE);
        pin2.setStroke((Stroke)new BasicStroke(1.5f));
        dialPlot.addLayer((DialLayer)pin2);
        DialCap dialCap = new DialCap();
        dialCap.setRadius(0.1);
        dialPlot.setCap((DialLayer)dialCap);
        JFreeChart jFreeChart = new JFreeChart((Plot)dialPlot);
        jFreeChart.setTitle(this.loggerData.getName());
        return jFreeChart;
    }

    private double rangeLimit(GaugeMinMax gaugeMinMax, double d) {
        return gaugeMinMax.min + (gaugeMinMax.max - gaugeMinMax.min) * d;
    }
}

