/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui;

import com.romraider.logger.ecu.ui.StatusChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public final class StatusIndicator
extends JPanel
implements StatusChangeListener {
    private static final long serialVersionUID = -3244690866698807677L;
    private final JLabel statusLabel = new JLabel();
    private static final String TEXT_CONNECTING = "Connecting to ECU...";
    private static final String TEXT_READING = "Reading data...";
    private static final String TEXT_LOGGING = "Logging data to file...";
    private static final String TEXT_STOPPED = "Stopped.";
    private static final ImageIcon ICON_CONNECTING = new ImageIcon("./graphics/logger_red.png");
    private static final ImageIcon ICON_READING = new ImageIcon("./graphics/logger_blue.png");
    private static final ImageIcon ICON_LOGGING = new ImageIcon("./graphics/logger_green.png");
    private static final ImageIcon ICON_STOPPED = new ImageIcon("./graphics/logger_red.png");

    public StatusIndicator() {
        this.setLayout(new BorderLayout());
        this.statusLabel.setFont(this.getFont().deriveFont(1));
        this.add((Component)this.statusLabel, "West");
        this.stopped();
    }

    public void connecting() {
        this.updateStatusLabel(TEXT_CONNECTING, ICON_CONNECTING);
    }

    public void readingData() {
        this.updateStatusLabel(TEXT_READING, ICON_READING);
    }

    public void loggingData() {
        this.updateStatusLabel(TEXT_LOGGING, ICON_LOGGING);
    }

    public void stopped() {
        this.updateStatusLabel(TEXT_STOPPED, ICON_STOPPED);
    }

    private void updateStatusLabel(final String string, final ImageIcon imageIcon) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusIndicator.this.statusLabel.setText(string);
                StatusIndicator.this.statusLabel.setIcon(imageIcon);
            }
        });
    }
}

