/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui;

import com.romraider.logger.ecu.comms.controller.LoggerController;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.DataRegistrationBroker;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandlerManager;
import com.romraider.util.ParamChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DataRegistrationBrokerImpl
implements DataRegistrationBroker {
    private final List<LoggerData> registeredLoggerData = Collections.synchronizedList(new ArrayList());
    private final LoggerController controller;
    private final DataUpdateHandlerManager handlerManager;
    private final String id;

    public DataRegistrationBrokerImpl(LoggerController loggerController, DataUpdateHandlerManager dataUpdateHandlerManager) {
        ParamChecker.checkNotNull(loggerController, dataUpdateHandlerManager);
        this.controller = loggerController;
        this.handlerManager = dataUpdateHandlerManager;
        this.id = System.currentTimeMillis() + "_" + this.hashCode();
    }

    public synchronized void registerLoggerDataForLogging(LoggerData loggerData) {
        if (!this.registeredLoggerData.contains(loggerData)) {
            this.handlerManager.registerData(loggerData);
            this.controller.addLogger(this.id, loggerData);
            this.registeredLoggerData.add(loggerData);
        }
    }

    public synchronized void deregisterLoggerDataFromLogging(LoggerData loggerData) {
        if (this.registeredLoggerData.contains(loggerData)) {
            this.deregisterLoggerDataFromDependants(loggerData);
            this.registeredLoggerData.remove(loggerData);
        }
    }

    public synchronized void clear() {
        for (LoggerData loggerData : this.registeredLoggerData) {
            this.deregisterLoggerDataFromDependants(loggerData);
        }
        this.registeredLoggerData.clear();
    }

    public synchronized void connecting() {
    }

    public synchronized void readingData() {
    }

    public synchronized void loggingData() {
    }

    public synchronized void stopped() {
    }

    private void deregisterLoggerDataFromDependants(LoggerData loggerData) {
        this.controller.removeLogger(this.id, loggerData);
        this.handlerManager.deregisterData(loggerData);
    }
}

