/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition.xml;

import com.romraider.logger.ecu.ui.handler.dash.GaugeMinMax;
import java.util.HashMap;
import java.util.Map;

public final class ConverterMaxMinDefaults {
    private static final Map<String, GaugeMinMax> DEFAULTS = new HashMap<String, GaugeMinMax>();
    private static final double MIN_DEFAULT = 0.0;
    private static final double MAX_DEFAULT = 100.0;
    private static final double STEP_DEFAULT = 10.0;
    private static final GaugeMinMax DEFAULT = new GaugeMinMax(0.0, 100.0, 10.0);

    public static double getMin(String string) {
        String string2 = string.toLowerCase();
        if (!DEFAULTS.containsKey(string2)) {
            return 0.0;
        }
        return ConverterMaxMinDefaults.DEFAULTS.get((Object)string2).min;
    }

    public static double getMax(String string) {
        String string2 = string.toLowerCase();
        if (!DEFAULTS.containsKey(string2)) {
            return 100.0;
        }
        return ConverterMaxMinDefaults.DEFAULTS.get((Object)string2).max;
    }

    public static double getStep(String string) {
        String string2 = string.toLowerCase();
        if (!DEFAULTS.containsKey(string2)) {
            return 10.0;
        }
        return ConverterMaxMinDefaults.DEFAULTS.get((Object)string2).step;
    }

    public static GaugeMinMax getDefault() {
        return DEFAULT;
    }

    public static GaugeMinMax getMaxMin(String string) {
        double d = ConverterMaxMinDefaults.getMin(string);
        double d2 = ConverterMaxMinDefaults.getMax(string);
        double d3 = ConverterMaxMinDefaults.getStep(string);
        return new GaugeMinMax(d, d2, d3);
    }

    private static void add(String string, double d, double d2, double d3) {
        String string2 = string.toLowerCase();
        GaugeMinMax gaugeMinMax = new GaugeMinMax(d, d2, d3);
        DEFAULTS.put(string2, gaugeMinMax);
    }

    static {
        ConverterMaxMinDefaults.add("%", 0.0, 100.0, 10.0);
        ConverterMaxMinDefaults.add("f", 0.0, 400.0, 40.0);
        ConverterMaxMinDefaults.add("c", -20.0, 200.0, 20.0);
        ConverterMaxMinDefaults.add("psi", -20.0, 40.0, 5.0);
        ConverterMaxMinDefaults.add("bar", -1.5, 3.0, 0.5);
        ConverterMaxMinDefaults.add("rpm", 0.0, 8000.0, 1000.0);
        ConverterMaxMinDefaults.add("mph", 0.0, 200.0, 20.0);
        ConverterMaxMinDefaults.add("kph", 0.0, 300.0, 20.0);
        ConverterMaxMinDefaults.add("degrees", -15.0, 60.0, 5.0);
        ConverterMaxMinDefaults.add("g/s", 0.0, 400.0, 20.0);
        ConverterMaxMinDefaults.add("v", 0.0, 5.0, 0.5);
        ConverterMaxMinDefaults.add("ms", 0.0, 100.0, 10.0);
        ConverterMaxMinDefaults.add("a", 0.0, 20.0, 5.0);
        ConverterMaxMinDefaults.add("ma", 0.0, 100.0, 10.0);
        ConverterMaxMinDefaults.add("steps", 0.0, 100.0, 10.0);
        ConverterMaxMinDefaults.add("ohms", 0.0, 100.0, 10.0);
        ConverterMaxMinDefaults.add("afr", 10.0, 20.0, 1.0);
        ConverterMaxMinDefaults.add("lambda", 0.5, 1.5, 0.1);
        ConverterMaxMinDefaults.add("gear", 0.0, 6.0, 1.0);
        ConverterMaxMinDefaults.add("misfire count", 0.0, 20.0, 5.0);
        ConverterMaxMinDefaults.add("mpa", 0.0, 0.5, 0.1);
        ConverterMaxMinDefaults.add("2*g/rev", 0.0, 8.0, 1.0);
        ConverterMaxMinDefaults.add("g/rev", 0.0, 4.0, 0.5);
        ConverterMaxMinDefaults.add("g/cyl", 0.0, 2.0, 0.5);
        ConverterMaxMinDefaults.add("multiplier", 0.0, 1.0, 0.1);
        ConverterMaxMinDefaults.add("raw ecu value", 0.0, 16.0, 1.0);
        ConverterMaxMinDefaults.add("status", 0.0, 10.0, 1.0);
        ConverterMaxMinDefaults.add("mmhg", 0.0, 2000.0, 100.0);
    }
}

