/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.comms.reset;

import com.romraider.Settings;
import com.romraider.logger.ecu.comms.io.connection.LoggerConnection;
import com.romraider.logger.ecu.comms.io.connection.LoggerConnectionFactory;
import com.romraider.logger.ecu.comms.reset.ResetManager;
import com.romraider.logger.ecu.ui.MessageListener;
import com.romraider.util.ParamChecker;
import org.apache.log4j.Logger;

public final class ResetManagerImpl
implements ResetManager {
    private static final Logger LOGGER = Logger.getLogger(ResetManagerImpl.class);
    private final Settings settings;
    private final MessageListener messageListener;

    public ResetManagerImpl(Settings settings, MessageListener messageListener) {
        ParamChecker.checkNotNull(settings, messageListener);
        this.settings = settings;
        this.messageListener = messageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetEcu() {
        LoggerConnection loggerConnection = LoggerConnectionFactory.getConnection(this.settings.getLoggerProtocol(), this.settings.getLoggerPort(), this.settings.getLoggerConnectionProperties());
        try {
            this.messageListener.reportMessage("Sending ECU Reset...");
            loggerConnection.ecuReset();
            this.messageListener.reportMessage("Sending ECU Reset...done.");
            boolean bl = true;
            loggerConnection.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                loggerConnection.close();
                throw throwable;
            }
            catch (Exception exception) {
                this.messageListener.reportMessage("Unable to reset ecu - check correct serial port has been selected, cable is connected and ignition is on.");
                LOGGER.error((Object)"Error sending ecu reset", (Throwable)exception);
                return false;
            }
        }
    }
}

