/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.io.protocol.ssm;

import com.romraider.io.connection.ConnectionProperties;
import com.romraider.io.protocol.Protocol;
import com.romraider.io.protocol.ssm.SSMChecksumCalculator;
import com.romraider.io.protocol.ssm.SSMResponseProcessor;
import com.romraider.logger.ecu.comms.query.EcuInit;
import com.romraider.logger.ecu.comms.query.SSMEcuInit;
import com.romraider.logger.ecu.exception.InvalidResponseException;
import com.romraider.util.ByteUtil;
import com.romraider.util.HexUtil;
import com.romraider.util.ParamChecker;

public final class SSMProtocol
implements Protocol {
    public static final byte HEADER = -128;
    public static final byte ECU_ID = 16;
    public static final byte DIAGNOSTIC_TOOL_ID = -16;
    public static final byte READ_PADDING = 0;
    public static final byte READ_MEMORY_COMMAND = -96;
    public static final byte READ_MEMORY_RESPONSE = -32;
    public static final byte READ_ADDRESS_COMMAND = -88;
    public static final byte READ_ADDRESS_RESPONSE = -24;
    public static final byte WRITE_MEMORY_COMMAND = -80;
    public static final byte WRITE_MEMORY_RESPONSE = -16;
    public static final byte WRITE_ADDRESS_COMMAND = -72;
    public static final byte WRITE_ADDRESS_RESPONSE = -8;
    public static final byte ECU_INIT_COMMAND = -65;
    public static final byte ECU_INIT_RESPONSE = -1;
    public static final int ADDRESS_SIZE = 3;
    public static final int DATA_SIZE = 1;
    public static final int RESPONSE_NON_DATA_BYTES = 6;
    public static final int REQUEST_NON_DATA_BYTES = 7;

    public byte[] constructEcuInitRequest() {
        return this.buildRequest((byte)-65, false, new byte[][]{new byte[0]});
    }

    public byte[] constructWriteMemoryRequest(byte[] byArray, byte[] byArray2) {
        ParamChecker.checkNotNullOrEmpty(byArray, "address");
        ParamChecker.checkNotNullOrEmpty(byArray2, "values");
        return this.buildRequest((byte)-80, false, byArray, byArray2);
    }

    public byte[] constructWriteAddressRequest(byte[] byArray, byte by) {
        ParamChecker.checkNotNullOrEmpty(byArray, "address");
        ParamChecker.checkNotNull((Object)by, "value");
        return this.buildRequest((byte)-72, false, byArray, {by});
    }

    public byte[] constructReadMemoryRequest(byte[] byArray, int n) {
        ParamChecker.checkNotNullOrEmpty(byArray, "address");
        ParamChecker.checkGreaterThanZero(n, "numBytes");
        return this.buildRequest((byte)-96, true, byArray, {ByteUtil.asByte(n - 1)});
    }

    public byte[] constructReadAddressRequest(byte[][] byArray) {
        ParamChecker.checkNotNullOrEmpty((Object[])byArray, "addresses");
        return this.buildRequest((byte)-88, true, byArray);
    }

    public byte[] preprocessResponse(byte[] byArray, byte[] byArray2) {
        return SSMResponseProcessor.filterRequestFromResponse(byArray, byArray2);
    }

    public byte[] parseResponseData(byte[] byArray) {
        ParamChecker.checkNotNullOrEmpty(byArray, "processedResponse");
        return SSMResponseProcessor.extractResponseData(byArray);
    }

    public void checkValidEcuInitResponse(byte[] byArray) {
        ParamChecker.checkNotNullOrEmpty(byArray, "processedResponse");
        SSMResponseProcessor.validateResponse(byArray);
        byte by = byArray[4];
        if (by != -1) {
            throw new InvalidResponseException("Unexpected ECU Init response type: " + HexUtil.asHex(new byte[]{by}));
        }
    }

    public EcuInit parseEcuInitResponse(byte[] byArray) {
        return new SSMEcuInit(this.parseResponseData(byArray));
    }

    public byte[] constructEcuResetRequest() {
        byte[] byArray = new byte[]{0, 0, 96, 64};
        return this.buildRequest((byte)-72, false, new byte[][]{byArray});
    }

    public void checkValidEcuResetResponse(byte[] byArray) {
        ParamChecker.checkNotNullOrEmpty(byArray, "processedResponse");
        SSMResponseProcessor.validateResponse(byArray);
        byte by = byArray[4];
        if (by != -8 || byArray[5] != 64) {
            throw new InvalidResponseException("Unexpected ECU Reset response: " + HexUtil.asHex(byArray));
        }
    }

    public ConnectionProperties getDefaultConnectionProperties() {
        return new ConnectionProperties(){

            public int getBaudRate() {
                return 4800;
            }

            public int getDataBits() {
                return 8;
            }

            public int getStopBits() {
                return 1;
            }

            public int getParity() {
                return 0;
            }

            public int getConnectTimeout() {
                return 2000;
            }

            public int getSendTimeout() {
                return 55;
            }
        };
    }

    private byte[] buildRequest(byte by, boolean bl, byte[] ... byArray) {
        byte[] byArray2 = new byte[]{};
        for (byte[] byArray3 : byArray) {
            byte[] byArray4 = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
            byArray2 = byArray4;
        }
        byte[] byArray5 = new byte[byArray2.length + (bl ? 7 : 6)];
        int n = 0;
        byArray5[n++] = -128;
        byArray5[n++] = 16;
        byArray5[n++] = -16;
        byArray5[n++] = ByteUtil.asByte(byArray2.length + (bl ? 2 : 1));
        byArray5[n++] = by;
        if (bl) {
            byArray5[n++] = 0;
        }
        System.arraycopy(byArray2, 0, byArray5, n, byArray2.length);
        byArray5[byArray5.length - 1] = SSMChecksumCalculator.calculateChecksum(byArray5);
        return byArray5;
    }
}

