/*
 * Decompiled with CFR 0.152.
 */
package com.romraider;

import com.romraider.io.connection.ConnectionProperties;
import com.romraider.logger.ecu.definition.EcuDefinition;
import com.romraider.util.ParamChecker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settings
implements Serializable {
    private static final long serialVersionUID = 1026542922680475190L;
    private Dimension windowSize = new Dimension(800, 600);
    private Point windowLocation = new Point();
    private int splitPaneLocation = 150;
    private boolean windowMaximized = false;
    private String recentVersion = "x";
    private Vector<File> ecuDefinitionFiles = new Vector();
    private File lastImageDir = new File("images");
    private boolean obsoleteWarning = true;
    private boolean calcConflictWarning = true;
    private boolean debug = false;
    private int userLevel = 1;
    private boolean saveDebugTables = true;
    private boolean displayHighTables = true;
    private boolean valueLimitWarning = true;
    private Font tableFont = new Font("Arial", 1, 11);
    private Dimension cellSize = new Dimension(42, 18);
    private Color maxColor = new Color(255, 102, 102);
    private Color minColor = new Color(153, 153, 255);
    private Color highlightColor = new Color(204, 204, 204);
    private Color increaseBorder = new Color(255, 0, 0);
    private Color decreaseBorder = new Color(0, 0, 255);
    private Color axisColor = new Color(255, 255, 255);
    private Color warningColor = new Color(255, 0, 0);
    private int tableClickCount = 1;
    private String loggerPort = "";
    private String loggerPortDefault = "";
    private String loggerProtocol = "SSM";
    private String loggerDefinitionFilePath = "";
    private String loggerProfileFilePath = "";
    private String loggerOutputDirPath = System.getProperty("user.home");
    private String fileLoggingControllerSwitchId = "S20";
    private boolean fileLoggingControllerSwitchActive = true;
    private boolean fileLoggingAbsoluteTimestamp = false;
    private Dimension loggerWindowSize = new Dimension(1000, 600);
    private Point loggerWindowLocation = new Point();
    private boolean loggerWindowMaximized = false;
    private int loggerSelectedTabIndex = 0;
    private ConnectionProperties loggerConnectionProperties;
    private Map<String, EcuDefinition> loggerEcuDefinitionMap;

    public Settings() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.windowLocation.move((int)(dimension.getWidth() - this.windowSize.getWidth()) / 2, (int)(dimension.getHeight() - this.windowSize.getHeight()) / 2);
    }

    public Dimension getWindowSize() {
        return this.windowSize;
    }

    public Point getWindowLocation() {
        return this.windowLocation;
    }

    public void setWindowSize(Dimension dimension) {
        this.windowSize.setSize(dimension);
    }

    public void setWindowLocation(Point point) {
        this.windowLocation.setLocation(point);
    }

    public Vector<File> getEcuDefinitionFiles() {
        return this.ecuDefinitionFiles;
    }

    public void addEcuDefinitionFile(File file) {
        this.ecuDefinitionFiles.add(file);
    }

    public void setEcuDefinitionFiles(Vector<File> vector) {
        this.ecuDefinitionFiles = vector;
    }

    public File getLastImageDir() {
        return this.lastImageDir;
    }

    public void setLastImageDir(File file) {
        this.lastImageDir = file;
    }

    public int getSplitPaneLocation() {
        return this.splitPaneLocation;
    }

    public void setSplitPaneLocation(int n) {
        this.splitPaneLocation = n;
    }

    public boolean isWindowMaximized() {
        return this.windowMaximized;
    }

    public void setWindowMaximized(boolean bl) {
        this.windowMaximized = bl;
    }

    public String getRomRevisionURL() {
        return "http://www.scoobypedia.co.uk/index.php/Knowledge/ECUVersionCompatibilityList";
    }

    public String getSupportURL() {
        return "http://www.romraider.com";
    }

    public Font getTableFont() {
        return this.tableFont;
    }

    public void setTableFont(Font font) {
        this.tableFont = font;
    }

    public boolean isObsoleteWarning() {
        return this.obsoleteWarning;
    }

    public void setObsoleteWarning(boolean bl) {
        this.obsoleteWarning = bl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(Dimension dimension) {
        this.cellSize = dimension;
    }

    public Color getMaxColor() {
        return this.maxColor;
    }

    public void setMaxColor(Color color) {
        this.maxColor = color;
    }

    public Color getMinColor() {
        return this.minColor;
    }

    public void setMinColor(Color color) {
        this.minColor = color;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public boolean isCalcConflictWarning() {
        return this.calcConflictWarning;
    }

    public void setCalcConflictWarning(boolean bl) {
        this.calcConflictWarning = bl;
    }

    public Color getIncreaseBorder() {
        return this.increaseBorder;
    }

    public void setIncreaseBorder(Color color) {
        this.increaseBorder = color;
    }

    public Color getDecreaseBorder() {
        return this.decreaseBorder;
    }

    public void setDecreaseBorder(Color color) {
        this.decreaseBorder = color;
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(Color color) {
        this.axisColor = color;
    }

    public int getUserLevel() {
        return this.userLevel;
    }

    public void setUserLevel(int n) {
        this.userLevel = n > 5 ? 5 : (n < 1 ? 1 : n);
    }

    public int getTableClickCount() {
        return this.tableClickCount;
    }

    public void setTableClickCount(int n) {
        this.tableClickCount = n;
    }

    public String getRecentVersion() {
        return this.recentVersion;
    }

    public void setRecentVersion(String string) {
        this.recentVersion = string;
    }

    public String getReleaseNotes() {
        return "release_notes.txt";
    }

    public boolean isSaveDebugTables() {
        return this.saveDebugTables;
    }

    public void setSaveDebugTables(boolean bl) {
        this.saveDebugTables = bl;
    }

    public boolean isDisplayHighTables() {
        return this.displayHighTables;
    }

    public void setDisplayHighTables(boolean bl) {
        this.displayHighTables = bl;
    }

    public boolean isValueLimitWarning() {
        return this.valueLimitWarning;
    }

    public void setValueLimitWarning(boolean bl) {
        this.valueLimitWarning = bl;
    }

    public Color getWarningColor() {
        return this.warningColor;
    }

    public void setWarningColor(Color color) {
        this.warningColor = color;
    }

    public String getLoggerPort() {
        return this.loggerPort;
    }

    public void setLoggerPort(String string) {
        this.loggerPort = string;
    }

    public String getLoggerPortDefault() {
        return this.loggerPortDefault;
    }

    public void setLoggerPortDefault(String string) {
        this.loggerPortDefault = string;
    }

    public String getLoggerProtocol() {
        return this.loggerProtocol;
    }

    public String getLoggerDefinitionFilePath() {
        return this.loggerDefinitionFilePath;
    }

    public void setLoggerDefinitionFilePath(String string) {
        this.loggerDefinitionFilePath = string;
    }

    public String getLoggerOutputDirPath() {
        return this.loggerOutputDirPath;
    }

    public Point getLoggerWindowLocation() {
        return this.loggerWindowLocation;
    }

    public void setLoggerWindowLocation(Point point) {
        this.loggerWindowLocation = point;
    }

    public boolean isLoggerWindowMaximized() {
        return this.loggerWindowMaximized;
    }

    public void setLoggerWindowMaximized(boolean bl) {
        this.loggerWindowMaximized = bl;
    }

    public Dimension getLoggerWindowSize() {
        return this.loggerWindowSize;
    }

    public void setLoggerWindowSize(Dimension dimension) {
        this.loggerWindowSize = dimension;
    }

    public String getLoggerProfileFilePath() {
        return this.loggerProfileFilePath;
    }

    public void setLoggerProfileFilePath(String string) {
        this.loggerProfileFilePath = string;
    }

    public void setLoggerOutputDirPath(String string) {
        this.loggerOutputDirPath = string;
    }

    public String getFileLoggingControllerSwitchId() {
        return this.fileLoggingControllerSwitchId;
    }

    public void setFileLoggingControllerSwitchId(String string) {
        ParamChecker.checkNotNullOrEmpty(string, "fileLoggingControllerSwitchId");
        this.fileLoggingControllerSwitchId = string;
    }

    public boolean isFileLoggingControllerSwitchActive() {
        return this.fileLoggingControllerSwitchActive;
    }

    public void setFileLoggingControllerSwitchActive(boolean bl) {
        this.fileLoggingControllerSwitchActive = bl;
    }

    public boolean isFileLoggingAbsoluteTimestamp() {
        return this.fileLoggingAbsoluteTimestamp;
    }

    public void setFileLoggingAbsoluteTimestamp(boolean bl) {
        this.fileLoggingAbsoluteTimestamp = bl;
    }

    public ConnectionProperties getLoggerConnectionProperties() {
        return this.loggerConnectionProperties;
    }

    public void setLoggerConnectionProperties(ConnectionProperties connectionProperties) {
        this.loggerConnectionProperties = connectionProperties;
    }

    public Map<String, EcuDefinition> getLoggerEcuDefinitionMap() {
        return this.loggerEcuDefinitionMap;
    }

    public void setLoggerEcuDefinitionMap(Map<String, EcuDefinition> map) {
        this.loggerEcuDefinitionMap = map;
    }

    public void setLoggerSelectedTabIndex(int n) {
        this.loggerSelectedTabIndex = n;
    }

    public int getLoggerSelectedTabIndex() {
        return this.loggerSelectedTabIndex;
    }
}

