/*
 * Decompiled with CFR 0.152.
 */
package com.romraider;

import com.romraider.ECUEditor;
import com.romraider.ECUEditorManager;
import com.romraider.Settings;
import com.romraider.logger.ecu.EcuLogger;
import com.romraider.swing.LookAndFeelManager;
import com.romraider.util.LogManager;
import com.romraider.util.RomServer;
import com.romraider.util.SettingsManagerImpl;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ECUExec {
    private static final Logger LOGGER = Logger.getLogger(ECUExec.class);
    private static final String START_LOGGER_ARG = "-logger";

    private ECUExec() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] stringArray) {
        LogManager.initDebugLogging();
        LookAndFeelManager.initLookAndFeel();
        if (RomServer.isRunning()) {
            if (stringArray.length == 0 || ECUExec.containsLoggerArg(stringArray)) {
                ECUExec.showAlreadyRunningMessage();
            } else {
                RomServer.sendRomToOpenInstance(stringArray[0]);
            }
        } else if (ECUExec.containsLoggerArg(stringArray)) {
            ECUExec.openLogger(stringArray);
        } else {
            ECUExec.openEditor(stringArray);
        }
    }

    private static void showAlreadyRunningMessage() {
        JOptionPane.showMessageDialog(null, "RomRaider is already running.", "RomRaider", 1);
    }

    private static boolean containsLoggerArg(String[] stringArray) {
        for (String string : stringArray) {
            if (!string.equals(START_LOGGER_ARG)) continue;
            return true;
        }
        return false;
    }

    private static void openLogger(String[] stringArray) {
        SettingsManagerImpl settingsManagerImpl = new SettingsManagerImpl();
        Settings settings = settingsManagerImpl.load();
        EcuLogger.startLogger(3, settings, stringArray);
    }

    private static void openRom(final ECUEditor eCUEditor, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    File file = new File(string);
                    eCUEditor.openImage(file);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Error opening rom", (Throwable)exception);
                }
            }
        });
    }

    private static void openEditor(String[] stringArray) {
        ECUEditor eCUEditor = ECUEditorManager.getECUEditor();
        if (stringArray.length > 0) {
            ECUExec.openRom(eCUEditor, stringArray[0]);
        }
        ECUExec.startRomListener(eCUEditor);
    }

    private static void startRomListener(ECUEditor eCUEditor) {
        try {
            while (true) {
                String string = RomServer.waitForRom();
                ECUExec.openRom(eCUEditor, string);
            }
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)"Error occurred", throwable);
            return;
        }
    }
}

