/*
 * Decompiled with CFR 0.152.
 */
package com.jinvoke.engine;

import com.jinvoke.Callback;
import com.jinvoke.Charset;
import com.jinvoke.Embedded;
import com.jinvoke.NativeStruct;
import java.io.IOException;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static int getStructSize(Object o) throws IllegalArgumentException, IOException, IllegalAccessException {
        return Util.getStructSize(o.getClass());
    }

    public static int getStructSize(Class structClass) throws IllegalArgumentException, IOException, IllegalAccessException {
        int remainder;
        Field[] fields = structClass.getFields();
        NativeStruct nativeAnno = structClass.getAnnotation(NativeStruct.class);
        if (nativeAnno == null) {
            throw new IllegalArgumentException("The class " + structClass + " does not have @NativeStruct annotation");
        }
        int packing = nativeAnno.packing();
        Charset charset = nativeAnno.charset();
        int size = 0;
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            size = Util.getStructMemberSize(field, size, packing, charset);
            ++i;
        }
        int structAlignment = Util.getNaturalAlignment(structClass, charset);
        if (structAlignment != 0 && (remainder = size % structAlignment) != 0) {
            size += structAlignment - remainder;
        }
        return size;
    }

    static int getStructMemberSize(Field field, int size, int packing, Charset charset) throws IllegalArgumentException, IOException, IllegalAccessException {
        Class<?> type = field.getType();
        int naturalalignment = Util.getNaturalAlignment(type, charset);
        int alignment = naturalalignment <= packing ? naturalalignment : packing;
        int gap = 0;
        int remainder = size % alignment;
        if (remainder > 0) {
            gap = alignment - remainder;
            size += gap;
        }
        if (type.getAnnotation(NativeStruct.class) != null) {
            size += Util.getStructSize(type);
        } else if (type.isArray()) {
            Embedded embeddedanno = field.getAnnotation(Embedded.class);
            if (embeddedanno != null) {
                int numelements = embeddedanno.length();
                Class<?> arraymembertype = type.getComponentType();
                size = arraymembertype.getAnnotation(NativeStruct.class) != null ? (size += numelements * Util.getStructSize(arraymembertype)) : (size += numelements * naturalalignment);
            } else {
                size += com.jinvoke.Util.sizeOfPointer();
            }
        } else if (type == String.class || type == StringBuffer.class || type == StringBuilder.class) {
            Embedded embeddedanno = field.getAnnotation(Embedded.class);
            if (embeddedanno != null) {
                int length = embeddedanno.length();
                size = charset == Charset.ANSI ? (size += length * com.jinvoke.Util.sizeOfChar()) : (size += length * com.jinvoke.Util.sizeOfWideChar());
            } else {
                size += com.jinvoke.Util.sizeOfPointer();
            }
        } else {
            size = type == Callback.class ? (size += com.jinvoke.Util.sizeOfPointer()) : (size += naturalalignment);
        }
        return size;
    }

    static int getNaturalAlignment(Class<? extends Object> type, Charset charset) {
        if (type.isArray()) {
            return Util.getNaturalAlignment(type.getComponentType(), charset);
        }
        if (type.getAnnotation(NativeStruct.class) != null) {
            NativeStruct structAnno = type.getAnnotation(NativeStruct.class);
            Charset charset2 = Charset.UNICODE;
            if (structAnno != null) {
                charset2 = structAnno.charset();
            }
            Field[] fields = type.getFields();
            int maxAlignment = 0;
            int i = 0;
            while (i < fields.length) {
                Class<?> subtype = fields[i].getType();
                int alnmnt = Util.getNaturalAlignment(subtype, charset2);
                if (alnmnt > maxAlignment) {
                    maxAlignment = alnmnt;
                }
                ++i;
            }
            return maxAlignment;
        }
        if (type == StringBuffer.class || type == StringBuilder.class) {
            if (charset == Charset.ANSI) {
                return com.jinvoke.Util.sizeOfChar();
            }
            return com.jinvoke.Util.sizeOfWideChar();
        }
        if (type == String.class) {
            return com.jinvoke.Util.sizeOfPointer();
        }
        if (Callback.class == type) {
            return com.jinvoke.Util.sizeOfPointer();
        }
        return Util.getPrimitiveSize(type, charset);
    }

    static int getPrimitiveSize(Class type, Charset charset) {
        int size = 0;
        if (type == Boolean.TYPE) {
            size += 4;
        } else if (type == Byte.TYPE) {
            ++size;
        } else if (type == Character.TYPE) {
            size = charset == Charset.UNICODE ? (size += 2) : ++size;
        } else if (type == Short.TYPE) {
            size += 2;
        } else if (type == Integer.TYPE) {
            size += 4;
        } else if (type == Long.TYPE) {
            size += 8;
        } else if (type == Float.TYPE) {
            size += 4;
        } else if (type == Boolean.class) {
            size += 2;
        } else if (type == Double.TYPE) {
            size += 8;
        } else if (type == Callback.class) {
            size += 4;
        } else {
            System.out.println("NativeStruct does not support members of type " + type + ".");
        }
        return size;
    }
}

