/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics.render.flatFaceRender;

import com.ecm.graphics.data.GraphData;
import com.ecm.graphics.render.flatFaceRender.DataChanger;
import com.ecm.graphics.render.flatFaceRender.Plane2d;
import com.ecm.graphics.tools.ColorTable;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;

public class Graph3dSmoothRender
extends TransformGroup
implements DataChanger {
    private int xWidth = GraphData.getXWidth();
    private int zDepth = GraphData.getZDepth();
    private float fudgedScaleYMax;

    public Graph3dSmoothRender(float fudgedScaleYMax) {
        this.fudgedScaleYMax = fudgedScaleYMax;
        this.setCapability(18);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(17);
        int i = 0;
        while (i < this.xWidth - 1) {
            int j = 0;
            while (j < this.zDepth - 1) {
                this.addChild((Node)this.getValueFace(i, j));
                ++j;
            }
            ++i;
        }
    }

    private Plane2d getValueFace(int x, int z) {
        float theValue1 = GraphData.getCellValue(x, z);
        float theValue2 = GraphData.getCellValue(x + 1, z);
        float theValue3 = GraphData.getCellValue(x + 1, z + 1);
        float theValue4 = GraphData.getCellValue(x, z + 1);
        Point3f A = new Point3f((float)x + 0.5f, this.getTransValue(theValue1), (float)(-z) - 0.5f);
        Point3f B = new Point3f((float)x + 1.5f, this.getTransValue(theValue2), (float)(-z) - 0.5f);
        Point3f C = new Point3f((float)x + 1.5f, this.getTransValue(theValue3), (float)(-z) - 1.5f);
        Point3f D = new Point3f((float)x + 0.5f, this.getTransValue(theValue4), (float)(-z) - 1.5f);
        Plane2d plane2d = new Plane2d(A, B, C, D, ColorTable.getColor(theValue1), false, x, z, theValue1, false);
        return plane2d;
    }

    private float getTransValue(float inValue) {
        return inValue / (float)GraphData.getMaxY() * this.fudgedScaleYMax;
    }

    public void modifyHeight(int x, int z, float value, int totalCount) {
    }
}

