/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics.graph3dTG;

import com.ecm.graphics.data.GraphData;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.math.BigDecimal;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Graph3dFrame
extends TransformGroup {
    private Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    private Color3f red = new Color3f(1.0f, 0.0f, 0.0f);
    private int xWidth = GraphData.getXWidth();
    private int zDepth = GraphData.getZDepth();
    private float fudgedScaleYMin;
    private float fudgedScaleYMax;
    private String xAxes;
    private String yAxes;
    private String zAxes;
    private double[] xAxesVals;
    private double[] zAxesVals;
    private FontExtrusion myExtrude;
    private Shape extrusionShape;

    public Graph3dFrame(float fudgedScaleYMin, float fudgedScaleYMax, double[] xAxesVals, double[] zAxesVals, String xAxes, String yAxes, String zAxes) {
        this.fudgedScaleYMax = fudgedScaleYMax;
        this.fudgedScaleYMin = fudgedScaleYMin;
        this.zAxes = zAxes;
        this.yAxes = yAxes;
        this.xAxes = xAxes;
        this.xAxesVals = xAxesVals;
        this.zAxesVals = zAxesVals;
        this.setCapability(18);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(17);
        double X1 = 0.0;
        double Y1 = 0.0;
        double X2 = 0.01;
        double Y2 = 0.0;
        this.extrusionShape = new Line2D.Double(X1, Y1, X2, Y2);
        this.myExtrude = new FontExtrusion(this.extrusionShape);
        this.addChild((Node)this.buildGrid());
        this.addChild((Node)this.buildAxes());
        this.addChild((Node)this.buildLabels());
    }

    private Shape3D getText(String textValue, int size) {
        Appearance app = new Appearance();
        ColoringAttributes ca = new ColoringAttributes(this.red, 2);
        app.setColoringAttributes(ca);
        Font myFont = new Font("Arial", 1, size);
        Font3D myFont3D = new Font3D(myFont, this.myExtrude);
        Text3D myText3D = new Text3D(myFont3D, textValue);
        Shape3D myShape3D = new Shape3D((Geometry)myText3D, app);
        return myShape3D;
    }

    private TransformGroup buildLabels() {
        Transform3D finalTransform = new Transform3D();
        finalTransform.setScale(0.6);
        TransformGroup labelTransformGroup = new TransformGroup();
        Shape3D xLabel3D = this.getText(this.xAxes, 2);
        Shape3D yLabel3D = this.getText(this.yAxes, 2);
        Shape3D zLabel3D = this.getText(this.zAxes, 2);
        Transform3D myTransform3DX = new Transform3D();
        myTransform3DX.setTranslation(new Vector3f((float)(this.xWidth / 4), this.fudgedScaleYMax + 2.0f, (float)(-this.zDepth)));
        myTransform3DX.mul(finalTransform);
        TransformGroup xTransformGroup = new TransformGroup(myTransform3DX);
        xTransformGroup.addChild((Node)xLabel3D);
        Transform3D myTransform3DY = new Transform3D();
        myTransform3DY.setTranslation(new Vector3f(1.0f, this.fudgedScaleYMin, 0.0f));
        myTransform3DY.mul(finalTransform);
        TransformGroup yTransformGroup = new TransformGroup(myTransform3DY);
        yTransformGroup.addChild((Node)yLabel3D);
        Transform3D myTransform3DZ = new Transform3D();
        myTransform3DZ.rotY(-1.5707963267948966);
        myTransform3DZ.setTranslation(new Vector3f((float)this.xWidth, this.fudgedScaleYMax + 2.0f, (float)(-3 * this.zDepth / 4)));
        myTransform3DZ.mul(finalTransform);
        TransformGroup zTransformGroup = new TransformGroup(myTransform3DZ);
        zTransformGroup.addChild((Node)zLabel3D);
        int i = 0;
        while (i < this.xWidth) {
            BigDecimal roundfinalPrice = new BigDecimal(this.xAxesVals[i]).setScale(2, 4);
            Double doublePrice = new Double(roundfinalPrice.doubleValue());
            Shape3D minorXLabel = this.getText(doublePrice.toString(), 1);
            float position = i;
            Transform3D xTrans3D = new Transform3D();
            xTrans3D.setTranslation(new Vector3f(position, this.fudgedScaleYMax + 1.0f, (float)(-this.zDepth)));
            xTrans3D.mul(finalTransform);
            xTrans3D.setScale(0.3);
            TransformGroup xTrans3DGroup = new TransformGroup(xTrans3D);
            xTrans3DGroup.addChild((Node)minorXLabel);
            labelTransformGroup.addChild((Node)xTrans3DGroup);
            ++i;
        }
        i = 0;
        while (i < this.zDepth) {
            Shape3D minorXLabel = this.getText(String.valueOf(this.zAxesVals[i]), 1);
            float position = -((float)this.zDepth - (float)i);
            Transform3D xTrans3D = new Transform3D();
            xTrans3D.rotY(-1.5707963267948966);
            xTrans3D.setTranslation(new Vector3f((float)this.xWidth, this.fudgedScaleYMax + 1.0f, position));
            xTrans3D.mul(finalTransform);
            xTrans3D.setScale(0.3);
            TransformGroup xTrans3DGroup = new TransformGroup(xTrans3D);
            xTrans3DGroup.addChild((Node)minorXLabel);
            labelTransformGroup.addChild((Node)xTrans3DGroup);
            ++i;
        }
        labelTransformGroup.addChild((Node)xTransformGroup);
        labelTransformGroup.addChild((Node)yTransformGroup);
        labelTransformGroup.addChild((Node)zTransformGroup);
        return labelTransformGroup;
    }

    private TransformGroup buildAxes() {
        float maxHeight = this.fudgedScaleYMax + 1.0f;
        Vector<Shape3D> myShapes = new Vector<Shape3D>();
        Appearance app = new Appearance();
        ColoringAttributes ca = new ColoringAttributes(this.black, 2);
        app.setColoringAttributes(ca);
        Point3f[] lineStart = new Point3f[3];
        Point3f[] lineEnded = new Point3f[3];
        lineStart[0] = new Point3f((float)this.xWidth, 0.0f, (float)(-this.zDepth));
        lineEnded[0] = new Point3f((float)this.xWidth, maxHeight, (float)(-this.zDepth));
        lineStart[1] = new Point3f((float)this.xWidth, maxHeight, (float)(-this.zDepth));
        lineEnded[1] = new Point3f(0.0f, maxHeight, (float)(-this.zDepth));
        lineStart[2] = new Point3f((float)this.xWidth, maxHeight, (float)(-this.zDepth));
        lineEnded[2] = new Point3f((float)this.xWidth, maxHeight, 0.0f);
        int i = 0;
        while (i < 3) {
            Point3f[] plaPts = new Point3f[]{lineStart[i], lineEnded[i]};
            LineArray pla = new LineArray(2, 1);
            pla.setCoordinates(0, plaPts);
            Shape3D plShape = new Shape3D((Geometry)pla, app);
            myShapes.add(plShape);
            ++i;
        }
        TransformGroup axesTransformGroup = new TransformGroup();
        for (Shape3D myshape3d : myShapes) {
            axesTransformGroup.addChild((Node)myshape3d);
        }
        return axesTransformGroup;
    }

    private TransformGroup buildGrid() {
        Vector<Shape3D> myShapes = new Vector<Shape3D>();
        Appearance app = new Appearance();
        ColoringAttributes ca = new ColoringAttributes(this.black, 2);
        app.setColoringAttributes(ca);
        int totalLineNumber = (this.xWidth + this.zDepth + 2) * 2;
        Point3f[] lineStart = new Point3f[totalLineNumber];
        Point3f[] lineEnded = new Point3f[totalLineNumber];
        int totalCount = 0;
        int i = 0;
        while (i < this.xWidth + 1) {
            lineStart[i] = new Point3f((float)i, this.fudgedScaleYMin, 0.0f);
            lineEnded[i] = new Point3f((float)i, this.fudgedScaleYMin, -((float)this.zDepth));
            ++totalCount;
            ++i;
        }
        i = this.xWidth + 1;
        while (i < (this.xWidth + 1) * 2) {
            lineStart[i] = new Point3f((float)i - (float)(this.xWidth + 1), this.fudgedScaleYMin, -((float)this.zDepth));
            lineEnded[i] = new Point3f((float)i - (float)(this.xWidth + 1), (float)((double)this.fudgedScaleYMax + 1.5), -((float)this.zDepth));
            ++totalCount;
            ++i;
        }
        i = totalCount;
        while (i < (this.xWidth + 1) * 2 + this.zDepth + 1) {
            lineStart[i] = new Point3f(0.0f, this.fudgedScaleYMin, -((float)((this.xWidth + 1) * 2 + this.zDepth) - (float)i));
            lineEnded[i] = new Point3f((float)this.xWidth, this.fudgedScaleYMin, -((float)((this.xWidth + 1) * 2 + this.zDepth) - (float)i));
            ++totalCount;
            ++i;
        }
        i = totalCount;
        while (i < (this.xWidth + 1) * 2 + (this.zDepth + 1) * 2) {
            lineStart[i] = new Point3f((float)this.xWidth, this.fudgedScaleYMin, -((float)((this.xWidth + 1) * 2 + (this.zDepth + 1) * 2) - (float)i) + 1.0f);
            lineEnded[i] = new Point3f((float)this.xWidth, (float)((double)this.fudgedScaleYMax + 1.5), -((float)((this.xWidth + 1) * 2 + (this.zDepth + 1) * 2) - (float)i) + 1.0f);
            ++totalCount;
            ++i;
        }
        i = 0;
        while (i < totalCount) {
            Point3f[] plaPts = new Point3f[]{lineStart[i], lineEnded[i]};
            LineArray pla = new LineArray(2, 1);
            pla.setCoordinates(0, plaPts);
            Shape3D plShape = new Shape3D((Geometry)pla, app);
            myShapes.add(plShape);
            ++i;
        }
        TransformGroup gridTransformGroup = new TransformGroup();
        for (Shape3D myshape3d : myShapes) {
            gridTransformGroup.addChild((Node)myshape3d);
        }
        return gridTransformGroup;
    }
}

