/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics.data;

import com.ecm.graphics.data.GraphDataCell;
import com.ecm.graphics.data.GraphDataCellCoordinate;
import com.ecm.graphics.data.GraphDataCellListener;
import com.ecm.graphics.data.GraphDataListener;
import com.ecm.graphics.tools.ColorTable;
import com.ecm.graphics.tools.FitData;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class GraphData {
    public static int NEW = 0;
    public static int REPLACE = 1;
    public static int INCRIMENT = 2;
    public static Vector GraphDataListeners = new Vector();
    private static GraphDataCell[][] graphData = null;
    private static int xWidth;
    private static int zDepth;
    private static double maxY;
    private static double minY;
    private static Vector scratchPad;
    private static GraphDataCellCoordinate lastSelectedCellCoord;
    private static GraphDataCellCoordinate diagSelectOne;
    private static GraphDataCellCoordinate diagSelectTwo;
    private static GraphDataCellCoordinate diagSelectOld;

    static {
        scratchPad = new Vector();
        lastSelectedCellCoord = null;
        diagSelectOne = null;
        diagSelectTwo = null;
        diagSelectOld = null;
    }

    public static void InitGraphData(Vector points, double aminY, double amaxY) {
        GraphDataListeners = new Vector();
        lastSelectedCellCoord = null;
        diagSelectOne = null;
        diagSelectTwo = null;
        diagSelectOld = null;
        maxY = amaxY;
        minY = aminY;
        GraphData.getDimensions(points);
        graphData = new GraphDataCell[xWidth][zDepth];
        GraphData.populateValueArray(points);
        ColorTable.initColorTable(minY, maxY);
        scratchPad.clear();
    }

    public static GraphDataCellCoordinate getSingleCount() {
        int counter = 0;
        GraphDataCell tempCell = null;
        int x = 0;
        int z = 0;
        int i = 0;
        while (i < zDepth) {
            int j = 0;
            while (j < xWidth) {
                tempCell = graphData[j][i];
                if (tempCell.getSelected()) {
                    ++counter;
                    x = tempCell.getX();
                    z = tempCell.getZ();
                }
                ++j;
            }
            ++i;
        }
        if (counter == 1) {
            return new GraphDataCellCoordinate(x, z);
        }
        return null;
    }

    public static void copySelectedToScratchPad() {
        scratchPad.clear();
        int i = 0;
        while (i < zDepth) {
            int j = 0;
            while (j < xWidth) {
                GraphDataCell dataCell = graphData[j][i];
                if (dataCell.getSelected()) {
                    scratchPad.add(dataCell);
                }
                ++j;
            }
            ++i;
        }
    }

    public static void pasteAtCoord() {
        GraphDataCellCoordinate newULcoord = GraphData.getSingleCount();
        if (newULcoord == null) {
            return;
        }
        GraphDataCell copyGDC = GraphData.getUpperLeftCoordCell();
        int xDiff = newULcoord.getX() - copyGDC.getX();
        int zDiff = newULcoord.getZ() - copyGDC.getZ();
        for (GraphDataCell tempCell : scratchPad) {
            tempCell.setSelected(false);
            int tempx = tempCell.getX();
            int tempz = tempCell.getZ();
            int newx = tempx + xDiff;
            int newz = tempz + zDiff;
            if (newx >= xWidth || newx < 0 || newz < 0 || newz >= zDepth) continue;
            graphData[newx][newz].setTempValue(tempCell.getValue());
            graphData[newx][newz].setSelected(true);
        }
        GraphData.applyDataCellChanges(REPLACE);
    }

    public static float getMinValue() {
        float minValue = 20.0f;
        int i = 0;
        while (i < zDepth) {
            int j = 0;
            while (j < xWidth) {
                float tempValue = graphData[j][i].getValue();
                if (tempValue < minValue) {
                    minValue = tempValue;
                }
                ++j;
            }
            ++i;
        }
        return minValue;
    }

    public static float getMaxValue() {
        float maxValue = 0.0f;
        int i = 0;
        while (i < zDepth) {
            int j = 0;
            while (j < xWidth) {
                float tempValue = graphData[j][i].getValue();
                if (tempValue > maxValue) {
                    maxValue = tempValue;
                }
                ++j;
            }
            ++i;
        }
        return maxValue;
    }

    public static float getCellValue(int x, int z) {
        return graphData[x][z].getValue();
    }

    public static Vector[][] getAllListeners(int x, int z) {
        Vector[][] listenerVectorsArray = new Vector[xWidth][zDepth];
        int i = 0;
        while (i < zDepth) {
            int j = 0;
            while (j < xWidth) {
                Vector listeners;
                listenerVectorsArray[j][i] = listeners = graphData[x][z].getListeners();
                ++j;
            }
            ++i;
        }
        return listenerVectorsArray;
    }

    public static void changeCellValue(float value, int type) {
        int i = 0;
        while (i < zDepth) {
            int j = 0;
            while (j < xWidth) {
                GraphDataCell dataCell = graphData[j][i];
                if (dataCell.getSelected()) {
                    dataCell.updateValue(value, type);
                    for (GraphDataListener gdl : GraphDataListeners) {
                        gdl.newGraphData(dataCell.getX(), dataCell.getZ(), dataCell.getValue());
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static void setSelected(int x, int z, boolean value) {
        lastSelectedCellCoord = new GraphDataCellCoordinate(x, z);
        graphData[x][z].setSelected(value);
        for (GraphDataListener gdl : GraphDataListeners) {
            gdl.selectStateChange(x, z, graphData[x][z].getSelected());
        }
    }

    public static void flipSelectedValue(GraphDataCellCoordinate gcc) {
        graphData[gcc.getX()][gcc.getZ()].flipSelected();
        if (graphData[gcc.getX()][gcc.getZ()].getSelected()) {
            lastSelectedCellCoord = new GraphDataCellCoordinate(gcc.getX(), gcc.getZ());
        }
        for (GraphDataListener gdl : GraphDataListeners) {
            gdl.selectStateChange(gcc.getX(), gcc.getZ(), graphData[gcc.getX()][gcc.getZ()].getSelected());
        }
    }

    public static void undoValueChange() {
        int i = 0;
        while (i < zDepth) {
            int j = 0;
            while (j < xWidth) {
                GraphDataCell dataCell = graphData[j][i];
                if (dataCell.getSelected()) {
                    dataCell.setTempValue(dataCell.getOldValue());
                    GraphData.notifyListeners(dataCell.getX(), dataCell.getZ(), dataCell.getOldValue());
                }
                ++j;
            }
            ++i;
        }
        GraphData.applyDataCellChanges(REPLACE);
    }

    public static void selectAllCells() {
        int i = 0;
        while (i < zDepth) {
            int j = 0;
            while (j < xWidth) {
                GraphDataCell dataCell = graphData[j][i];
                dataCell.setSelected(true);
                ++j;
            }
            ++i;
        }
    }

    public static void deSelectAllCells() {
        int i = 0;
        while (i < zDepth) {
            int j = 0;
            while (j < xWidth) {
                GraphDataCell dataCell = graphData[j][i];
                dataCell.setSelected(false);
                ++j;
            }
            ++i;
        }
    }

    public static void smoothXData() {
        GraphData.smoothDataXDirection();
        GraphData.applyDataCellChanges(REPLACE);
    }

    public static void smoothZData() {
        GraphData.smoothDataZDirection();
        GraphData.applyDataCellChanges(REPLACE);
    }

    public static void totalSmooth() {
        GraphData.smoothDataXDirection();
        GraphData.smoothDataZDirection();
        GraphData.applyDataCellChanges(REPLACE);
    }

    public static void setLineSelectedFalse(GraphDataCellCoordinate coordOne, GraphDataCellCoordinate coordTwo) {
        int i;
        int xOne = coordOne.getX();
        int zOne = coordOne.getZ();
        int xTwo = coordTwo.getX();
        int zTwo = coordTwo.getZ();
        if (xOne == xTwo) {
            int zMin = Math.min(zOne, zTwo);
            int zMax = Math.max(zOne, zTwo);
            i = zMin;
            while (i < zMax + 1) {
                GraphData.setSelected(xOne, i, false);
                ++i;
            }
        }
        if (zOne == zTwo) {
            int xMin = Math.min(xOne, xTwo);
            int xMax = Math.max(xOne, xTwo);
            i = xMin;
            while (i < xMax + 1) {
                GraphData.setSelected(i, zOne, false);
                ++i;
            }
        }
    }

    public static int getSelectedCount() {
        int counter = 0;
        int i = 0;
        while (i < zDepth) {
            int j = 0;
            while (j < xWidth) {
                GraphDataCell dataCell = graphData[j][i];
                if (dataCell.getSelected()) {
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
        return counter;
    }

    public static void drawRectDiagonalSelection() {
        GraphData.drawRectDiagWithState(false, GraphData.getDiagSelectOne(), GraphData.getDiagSelectOld());
        GraphData.drawRectDiagWithState(true, GraphData.getDiagSelectOne(), GraphData.getDiagSelectTwo());
    }

    private static void drawRectDiagWithState(boolean value, GraphDataCellCoordinate one, GraphDataCellCoordinate two) {
        if (one != null && two != null) {
            int xOne = one.getX();
            int zOne = one.getZ();
            int xTwo = two.getX();
            int zTwo = two.getZ();
            int tempX = Math.min(xOne, xTwo);
            int tempZ = Math.min(zOne, zTwo);
            int xWidth = Math.abs(xTwo - xOne);
            int zHeight = Math.abs(zTwo - zOne);
            if (xOne != xTwo || zOne != zTwo) {
                int i = tempZ;
                while (i < tempZ + zHeight + 1) {
                    int j = tempX;
                    while (j < tempX + xWidth + 1) {
                        GraphData.setSelected(j, i, value);
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    private static void populateValueArray(Vector points) {
        Iterator pointIterate = points.iterator();
        int counter = 0;
        while (pointIterate.hasNext()) {
            float[] line = (float[])pointIterate.next();
            int i = 0;
            while (i < line.length) {
                GraphData.graphData[i][counter] = new GraphDataCell(line[i], i, counter);
                ++i;
            }
            ++counter;
        }
    }

    private static void getDimensions(Vector points) {
        Iterator pointsIterator = points.iterator();
        int iterateCounter = 0;
        while (pointsIterator.hasNext()) {
            ++iterateCounter;
            float[] line = (float[])pointsIterator.next();
            if (line == null || line.length == 0) {
                System.err.println("Points table lacks data.");
                System.exit(0);
            }
            int lineLength = line.length;
            if (iterateCounter > 1 && lineLength != xWidth) {
                System.err.println("Dimensionality does not hold, lines of unequal length data.");
                System.exit(0);
            }
            xWidth = lineLength;
            zDepth = iterateCounter;
        }
    }

    private static double getPointDistance(GraphDataCellCoordinate a, GraphDataCellCoordinate b) {
        return Math.sqrt(Math.pow(Math.abs(a.getX() - b.getX()), 2.0) + Math.pow(Math.abs(a.getZ() - b.getZ()), 2.0));
    }

    private static GraphDataCell getUpperLeftCoordCell() {
        int x = xWidth;
        int z = 0;
        for (GraphDataCell tempData : scratchPad) {
            if (tempData.getX() < x) {
                x = tempData.getX();
            }
            if (tempData.getZ() <= z) continue;
            z = tempData.getZ();
        }
        return graphData[x][z];
    }

    private static void notifyListeners(int x, int z, float value) {
        for (GraphDataListener gdl : GraphDataListeners) {
            gdl.newGraphData(x, z, value);
        }
    }

    private static void applyDataCellChanges(int type) {
        int i = 0;
        while (i < zDepth) {
            int j = 0;
            while (j < xWidth) {
                GraphDataCell dataCell = graphData[j][i];
                if (dataCell.getSelected()) {
                    dataCell.applyTempValue(type);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void smoothDataXDirection() {
        int i = 0;
        while (i < zDepth) {
            LinkedList<GraphDataCell> smoothXCells = new LinkedList<GraphDataCell>();
            int j = 0;
            while (j < xWidth) {
                GraphDataCell dataCell = graphData[j][i];
                if (dataCell.getSelected()) {
                    if (smoothXCells.isEmpty()) {
                        smoothXCells.add(dataCell);
                    } else {
                        GraphDataCell lastCell = (GraphDataCell)smoothXCells.getLast();
                        if (lastCell.getX() == dataCell.getX() - 1) {
                            smoothXCells.add(dataCell);
                        } else if (smoothXCells.size() > 2) {
                            GraphData.smoothListDataX(smoothXCells);
                        } else {
                            smoothXCells.clear();
                        }
                    }
                }
                if (j == xWidth - 1) {
                    if (smoothXCells.size() > 2) {
                        GraphData.smoothListDataX(smoothXCells);
                    }
                    smoothXCells.clear();
                }
                ++j;
            }
            ++i;
        }
    }

    public static void smoothDataZDirection() {
        int i = 0;
        while (i < xWidth) {
            LinkedList<GraphDataCell> smoothYCells = new LinkedList<GraphDataCell>();
            int j = 0;
            while (j < zDepth) {
                GraphDataCell dataCell = graphData[i][j];
                if (dataCell.getSelected()) {
                    if (smoothYCells.isEmpty()) {
                        smoothYCells.add(dataCell);
                    } else {
                        GraphDataCell lastCell = (GraphDataCell)smoothYCells.getLast();
                        if (lastCell.getZ() == dataCell.getZ() - 1) {
                            smoothYCells.add(dataCell);
                        } else if (smoothYCells.size() > 2) {
                            GraphData.smoothListDataY(smoothYCells);
                        } else {
                            smoothYCells.clear();
                        }
                    }
                }
                if (j == zDepth - 1) {
                    if (smoothYCells.size() > 2) {
                        GraphData.smoothListDataY(smoothYCells);
                    }
                    smoothYCells.clear();
                }
                ++j;
            }
            ++i;
        }
    }

    private static void smoothListDataY(LinkedList smoothXCells) {
        Iterator smoothIterate = smoothXCells.iterator();
        double[] xVals = new double[smoothXCells.size()];
        double[] yVals = new double[smoothXCells.size()];
        int counter = 0;
        while (smoothIterate.hasNext()) {
            GraphDataCell tempCell = (GraphDataCell)smoothIterate.next();
            xVals[counter] = tempCell.getZ();
            yVals[counter] = tempCell.getTempValue();
            ++counter;
        }
        FitData.init(xVals, yVals);
        for (GraphDataCell tempCell : smoothXCells) {
            double xValue = tempCell.getZ();
            double smoothYValue = FitData.getSmoothYValue(xValue);
            tempCell.setTempValue((float)smoothYValue);
            for (GraphDataListener gdl : GraphDataListeners) {
                gdl.newGraphData(tempCell.getX(), tempCell.getZ(), (float)smoothYValue);
            }
        }
        smoothXCells.clear();
    }

    private static void smoothListDataX(LinkedList smoothXCells) {
        Iterator smoothIterate = smoothXCells.iterator();
        double[] xVals = new double[smoothXCells.size()];
        double[] yVals = new double[smoothXCells.size()];
        int counter = 0;
        while (smoothIterate.hasNext()) {
            GraphDataCell tempCell = (GraphDataCell)smoothIterate.next();
            xVals[counter] = tempCell.getX();
            yVals[counter] = tempCell.getTempValue();
            ++counter;
        }
        FitData.init(xVals, yVals);
        for (GraphDataCell tempCell : smoothXCells) {
            double xValue = tempCell.getX();
            double smoothYValue = FitData.getSmoothYValue(xValue);
            tempCell.setTempValue((float)smoothYValue);
            for (GraphDataListener gdl : GraphDataListeners) {
                gdl.newGraphData(tempCell.getX(), tempCell.getZ(), (float)smoothYValue);
            }
        }
        smoothXCells.clear();
    }

    public static double getMaxY() {
        return maxY;
    }

    public static double getMinY() {
        return minY;
    }

    public static double getHeight() {
        return Math.abs(maxY) + Math.abs(minY);
    }

    public static void addGraphDataListener(GraphDataListener gdl) {
        GraphDataListeners.add(gdl);
    }

    public static void addGraphDataCellListener(int x, int z, GraphDataCellListener listener) {
        graphData[x][z].addDataListener(listener);
    }

    public static GraphDataCellCoordinate getLastSelectedCoord() {
        return lastSelectedCellCoord;
    }

    public static int getXWidth() {
        return xWidth;
    }

    public static int getZDepth() {
        return zDepth;
    }

    public static GraphDataCellCoordinate getDiagSelectOne() {
        return diagSelectOne;
    }

    public static GraphDataCellCoordinate getDiagSelectTwo() {
        return diagSelectTwo;
    }

    public static void setDiagSelectOne(GraphDataCellCoordinate one) {
        if (diagSelectOne == null) {
            diagSelectOld = one;
            diagSelectTwo = one;
        }
        diagSelectOne = one;
    }

    public static void setDiagSelectTwo(GraphDataCellCoordinate passedCoord) {
        if (passedCoord == diagSelectTwo) {
            return;
        }
        diagSelectOld = diagSelectTwo;
        if (diagSelectTwo == null) {
            diagSelectOld = passedCoord;
        }
        if (passedCoord == null) {
            diagSelectOld = null;
        }
        diagSelectTwo = passedCoord;
    }

    public static GraphDataCellCoordinate getDiagSelectOld() {
        return diagSelectOld;
    }
}

