/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.RandomAccessFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;

class PBEditor
extends JPanel
implements ActionListener,
KeyListener {
    boolean DEBUG = false;
    private RandomAccessFile currBINFile = null;
    private SimpleTableDemo TablePane = null;
    private int[][] orig_data = new int[IgnTableModel.NUM_COLS - 1][IgnTableModel.NUM_ROWS];
    private int[][] orig_data_f1 = new int[FuelTableModel.NUM_COLS - 1][FuelTableModel.NUM_ROWS + 1];
    private int[][] orig_data_f2 = new int[FuelTableModel.NUM_COLS - 1][FuelTableModel.NUM_ROWS + 1];
    private int[][] orig_data_f3 = new int[FuelTableModel.NUM_COLS - 1][FuelTableModel.NUM_ROWS + 1];
    private String[] fuelTables = new String[]{"Fuel Table 1", "Fuel Table 2", "Fuel Table 3"};
    private JComboBox fuelChoose = new JComboBox<String>(this.fuelTables);
    private int curFuel = 1;

    public void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
    }

    PBEditor() {
        super(true);
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Load BIN File");
        JButton jButton2 = new JButton("Save BIN File");
        JButton jButton3 = new JButton("Dump RAW MAP");
        jButton.setMnemonic('l');
        jButton2.setMnemonic('s');
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jButton.setActionCommand("loadBIN");
        jButton2.setActionCommand("saveBIN");
        jButton3.setActionCommand("dumpData");
        jPanel.setLayout(new BorderLayout());
        this.fuelChoose.setSelectedIndex(0);
        this.fuelChoose.setActionCommand("chooseFuel");
        this.fuelChoose.addActionListener(this);
        this.TablePane = new SimpleTableDemo();
        this.TablePane.setOpaque(true);
        this.TablePane.table.addKeyListener(this);
        this.TablePane.table1.addKeyListener(this);
        this.add("South", jButton);
        this.add("West", jButton2);
        this.add("Center", this.fuelChoose);
        this.add("East", jButton3);
        this.add("North", this.TablePane);
    }

    public static void main(String[] stringArray) {
        try {
            String string = System.getProperty("java.version");
            if (string.compareTo("1.1.2") < 0) {
                System.out.println("!!!WARNING: Swing must be run with a 1.1.2 or higher version VM!!!");
            }
            JFrame jFrame = new JFrame("PsyBIN Editor");
            jFrame.setBackground(Color.lightGray);
            jFrame.getContentPane().setLayout(new BorderLayout());
            PBEditor pBEditor = new PBEditor();
            jFrame.getContentPane().add("Center", pBEditor);
            jFrame.addWindowListener(new AppCloser());
            jFrame.pack();
            jFrame.setSize(780, 350);
            jFrame.setVisible(true);
        }
        catch (Throwable throwable) {
            System.out.println("uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyTyped(KeyEvent keyEvent) {
        int[] nArray;
        int[] nArray2;
        int[][] nArray3;
        if (keyEvent.getKeyChar() != 'i' && keyEvent.getKeyChar() != 'I' && keyEvent.getKeyChar() != 'd' && keyEvent.getKeyChar() != 'D') return;
        boolean bl = false;
        boolean bl2 = false;
        if (keyEvent.getSource().equals(this.TablePane.table)) {
            nArray3 = this.orig_data;
            nArray2 = this.TablePane.table.getSelectedRows();
            nArray = this.TablePane.table.getSelectedColumns();
        } else {
            if (!keyEvent.getSource().equals(this.TablePane.table1)) return;
            bl2 = true;
            nArray2 = this.TablePane.table1.getSelectedRows();
            nArray = this.TablePane.table1.getSelectedColumns();
            if (this.curFuel == 1) {
                nArray3 = this.orig_data_f1;
            } else if (this.curFuel == 2) {
                nArray3 = this.orig_data_f2;
            } else {
                if (this.curFuel != 3) return;
                nArray3 = this.orig_data_f3;
            }
        }
        if (nArray2.length > 0 && nArray.length > 0) {
            for (int i = 0; i < nArray2.length; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    if (this.currBINFile == null) continue;
                    int n = nArray2[i];
                    int n2 = nArray[j] - 1;
                    if (n2 < 0) continue;
                    if (keyEvent.getKeyChar() == 'i' || keyEvent.getKeyChar() == 'I') {
                        if (nArray3[n2][n] >= 255) continue;
                        int[] nArray4 = nArray3[n2];
                        int n3 = n;
                        nArray4[n3] = nArray4[n3] + 1;
                        bl = true;
                        continue;
                    }
                    if (nArray3[n2][n] <= 0) continue;
                    int[] nArray5 = nArray3[n2];
                    int n4 = n;
                    nArray5[n4] = nArray5[n4] - 1;
                    bl = true;
                }
            }
        }
        if (!bl) return;
        if (bl2) {
            this.setFuelTable(this.curFuel);
            return;
        } else {
            this.updateIgnTableData();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        int n;
        if (actionEvent.getActionCommand().equals("chooseFuel") && this.currBINFile != null) {
            this.curFuel = this.fuelChoose.getSelectedIndex() != -1 ? this.fuelChoose.getSelectedIndex() + 1 : 1;
            this.setFuelTable(this.curFuel);
        }
        if (actionEvent.getActionCommand().equals("dumpData")) {
            int n2;
            for (n = 0; n < IgnTableModel.NUM_ROWS; ++n) {
                object = new String("Ign" + n + ": ");
                for (n2 = 0; n2 < IgnTableModel.NUM_COLS - 1; ++n2) {
                    object = ((String)object).concat(Integer.toHexString(this.orig_data[n2][n]) + " ");
                }
                System.err.println((String)object);
            }
            System.err.println("-------------------");
            for (n = 0; n < FuelTableModel.NUM_ROWS; ++n) {
                object = new String("F1_" + n + ": ");
                for (n2 = 0; n2 < FuelTableModel.NUM_COLS - 1; ++n2) {
                    object = ((String)object).concat(Integer.toHexString(this.orig_data_f1[n2][n]) + " ");
                }
                System.err.println((String)object);
            }
            object = new String("Mult1: ");
            for (n = 0; n < FuelTableModel.NUM_COLS - 1; ++n) {
                object = ((String)object).concat(Integer.toHexString(this.orig_data_f1[n][FuelTableModel.NUM_ROWS]) + " ");
            }
            System.err.println((String)object);
            System.err.println("-------------------");
            for (n = 0; n < FuelTableModel.NUM_ROWS; ++n) {
                object = new String("F2_" + n + ": ");
                for (n2 = 0; n2 < FuelTableModel.NUM_COLS - 1; ++n2) {
                    object = ((String)object).concat(Integer.toHexString(this.orig_data_f2[n2][n]) + " ");
                }
                System.err.println((String)object);
            }
            object = new String("Mult2: ");
            for (n = 0; n < FuelTableModel.NUM_COLS - 1; ++n) {
                object = ((String)object).concat(Integer.toHexString(this.orig_data_f2[n][FuelTableModel.NUM_ROWS]) + " ");
            }
            System.err.println((String)object);
            System.err.println("-------------------");
            for (n = 0; n < FuelTableModel.NUM_ROWS; ++n) {
                object = new String("F3_" + n + ": ");
                for (n2 = 0; n2 < FuelTableModel.NUM_COLS - 1; ++n2) {
                    object = ((String)object).concat(Integer.toHexString(this.orig_data_f3[n2][n]) + " ");
                }
                System.err.println((String)object);
            }
            object = new String("Mult3: ");
            for (n = 0; n < FuelTableModel.NUM_COLS - 1; ++n) {
                object = ((String)object).concat(Integer.toHexString(this.orig_data_f3[n][FuelTableModel.NUM_ROWS]) + " ");
            }
            System.err.println((String)object);
        }
        if (actionEvent.getActionCommand().equals("loadBIN") && (n = ((JFileChooser)(object = new JFileChooser())).showOpenDialog(this)) == 0) {
            File file = ((JFileChooser)object).getSelectedFile();
            if (file.canRead() && file.canWrite()) {
                try {
                    this.currBINFile = new RandomAccessFile(file, "rw");
                }
                catch (Exception exception) {}
            } else if (file.canRead()) {
                try {
                    this.currBINFile = new RandomAccessFile(file, "r");
                }
                catch (Exception exception) {}
            } else {
                System.err.println("Error: Cannot open file.");
            }
            if (this.currBINFile != null) {
                if (this.DEBUG) {
                    System.err.println("Reading file: " + file.getAbsolutePath());
                }
                this.parseOneTable(this.currBINFile, IgnTableModel.NUM_ROWS, IgnTableModel.NUM_COLS - 1, 16022, 16036, this.TablePane.table, this.orig_data, true);
                this.updateIgnTableData();
                this.parseOneTable(this.currBINFile, FuelTableModel.NUM_ROWS, FuelTableModel.NUM_COLS - 1, 15588, 15599, this.TablePane.table1, this.orig_data_f1, false);
                this.parseOneTable(this.currBINFile, FuelTableModel.NUM_ROWS, FuelTableModel.NUM_COLS - 1, 15682, 15693, this.TablePane.table1, this.orig_data_f2, false);
                this.parseOneTable(this.currBINFile, FuelTableModel.NUM_ROWS, FuelTableModel.NUM_COLS - 1, 15776, 15787, this.TablePane.table1, this.orig_data_f3, false);
                this.fuelChoose.setSelectedIndex(0);
                this.setFuelTable(this.curFuel);
            }
        }
        if (actionEvent.getActionCommand().equals("saveBIN") && this.currBINFile != null) {
            try {
                this.currBINFile.seek(8020L);
                int n3 = this.currBINFile.readUnsignedByte();
                if (n3 == 201) {
                    this.currBINFile.seek(8020L);
                    this.currBINFile.writeByte(203);
                } else if (n3 == 203) {
                    System.err.println("INFO: checksum is already removed.");
                } else {
                    System.err.println("ERROR: checksum CANNOT be removed.");
                }
            }
            catch (Exception exception) {
                System.err.println("Cannot Write: " + exception.getMessage());
            }
            this.saveOneTable(this.currBINFile, IgnTableModel.NUM_ROWS, IgnTableModel.NUM_COLS - 1, 16036, this.orig_data);
            this.saveOneTable(this.currBINFile, FuelTableModel.NUM_ROWS, FuelTableModel.NUM_COLS - 1, 15599, this.orig_data_f1);
            this.saveOneTable(this.currBINFile, FuelTableModel.NUM_ROWS, FuelTableModel.NUM_COLS - 1, 15693, this.orig_data_f2);
            this.saveOneTable(this.currBINFile, FuelTableModel.NUM_ROWS, FuelTableModel.NUM_COLS - 1, 15787, this.orig_data_f3);
        }
    }

    private void saveOneTable(RandomAccessFile randomAccessFile, int n, int n2, int n3, int[][] nArray) {
        try {
            randomAccessFile.seek(n3);
            for (int i = 0; i < n; ++i) {
                for (int j = 1; j < n2 + 1; ++j) {
                    int n4 = nArray[j - 1][i];
                    randomAccessFile.writeByte(n4);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Cannot Write: " + exception.getMessage());
        }
    }

    private void parseOneTable(RandomAccessFile randomAccessFile, int n, int n2, int n3, int n4, JTable jTable, int[][] nArray, boolean bl) {
        try {
            if (randomAccessFile.length() >= 32768L) {
                int n5;
                int n6;
                int n7 = 0;
                int n8 = 0;
                for (n6 = n2; n6 > 0; --n6) {
                    randomAccessFile.seek(n3 - n7);
                    if (n7 == 0) {
                        n8 = 256;
                    } else {
                        int n9 = randomAccessFile.readUnsignedByte();
                        n8 -= n9;
                    }
                    ++n7;
                    if (this.DEBUG) {
                        System.err.println("MAP: " + n8);
                    }
                    try {
                        if (jTable == null) continue;
                        String string = this.convertMAPHeaderToMBAR(n8);
                        if (this.DEBUG) {
                            System.err.println("txtMAP: " + string);
                        }
                        this.TablePane.setColumnHeader(jTable, string, n6);
                        continue;
                    }
                    catch (Exception exception) {
                        System.err.println("Error: " + exception.getMessage());
                    }
                }
                n7 = 0;
                n6 = 0;
                for (n5 = n - 1; n5 >= 0; --n5) {
                    randomAccessFile.seek(n4 - n7);
                    if (n7 == 0) {
                        n6 = 256;
                    } else {
                        int n10 = randomAccessFile.readUnsignedByte();
                        n6 -= n10;
                    }
                    ++n7;
                    if (this.DEBUG) {
                        System.err.println("RPM: " + n6);
                    }
                    try {
                        if (jTable == null) continue;
                        String string = this.convertRPM(n6);
                        if (this.DEBUG) {
                            System.err.println("txtRPM: " + string);
                        }
                        jTable.setValueAt(string, n5, 0);
                        continue;
                    }
                    catch (Exception exception) {
                        System.err.println("Error: " + exception.getMessage());
                    }
                }
                randomAccessFile.seek(n4);
                for (n5 = 0; n5 < n; ++n5) {
                    for (int i = 1; i < n2 + 1; ++i) {
                        int n11 = randomAccessFile.readUnsignedByte();
                        if (this.DEBUG) {
                            System.err.println("addr: " + randomAccessFile.getFilePointer() + " data: " + n11);
                        }
                        nArray[i - 1][n5] = n11;
                    }
                }
                if (!bl) {
                    randomAccessFile.seek(n4 + n * n2);
                    for (n5 = 1; n5 < n2 + 1; ++n5) {
                        int n12 = randomAccessFile.readUnsignedByte();
                        if (this.DEBUG) {
                            System.err.println("mult: " + randomAccessFile.getFilePointer() + " data: " + n12);
                        }
                        nArray[n5 - 1][n] = n12;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error reading file.");
        }
    }

    private void updateIgnTableData() {
        for (int i = 0; i < 15; ++i) {
            for (int j = 1; j < 9; ++j) {
                try {
                    if (this.TablePane.table == null) continue;
                    this.TablePane.table.getModel().setValueAt(this.convertBinValueToFloat(this.orig_data[j - 1][i]), i, j);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Error: " + exception.getMessage());
                }
            }
        }
        this.repaint();
    }

    private String convertRPM(int n) {
        Integer n2 = new Integer((int)(28.61023 * (double)n));
        String string = n2.toString();
        return string;
    }

    private String convertMAPHeaderToMBAR(int n) {
        Integer n2 = new Integer((int)((double)n * 4.043));
        String string = n2.toString();
        return string;
    }

    private Float convertBinValueToFloat(int n) {
        return new Float((double)(n - 15) * 0.29);
    }

    private void setFuelTable(int n) {
        if (n == 1) {
            this.updateFuelTableData(this.orig_data_f1);
        } else if (n == 2) {
            this.updateFuelTableData(this.orig_data_f2);
        } else if (n == 3) {
            this.updateFuelTableData(this.orig_data_f3);
        } else {
            System.err.println("ERROR: unknown table!");
        }
    }

    private void updateFuelTableData(int[][] nArray) {
        int n = FuelTableModel.NUM_ROWS;
        for (int i = 0; i < FuelTableModel.NUM_ROWS; ++i) {
            for (int j = 1; j < FuelTableModel.NUM_COLS; ++j) {
                try {
                    if (this.TablePane.table1 == null) continue;
                    this.TablePane.table1.getModel().setValueAt(this.convertBinFuelToMsec(nArray[j - 1][i], nArray[j - 1][n]), i, j);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Error: " + exception.getMessage());
                }
            }
        }
        this.repaint();
    }

    private Float convertBinFuelToMsec(int n, int n2) {
        double d = Math.pow(2.0, n2);
        double d2 = ((double)n + 224.0 / d) / (127.0 / d);
        Float f = new Float((float)d2);
        return f;
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }
}

